/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.osgi;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.file.storage.FileStorageAccountManagerLookupService;
import com.openexchange.file.storage.internal.FileStorageConfigReloadable;
import com.openexchange.file.storage.internal.FileStorageQuotaProvider;
import com.openexchange.file.storage.osgi.OSGIFileStorageAccountManagerLookupService;
import com.openexchange.file.storage.osgi.OSGIFileStorageServiceRegistry;
import com.openexchange.file.storage.osgi.Services;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.osgi.HousekeepingActivator;
import com.openexchange.quota.QuotaProvider;
import com.openexchange.secret.SecretService;
import com.openexchange.server.ServiceLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileStorageActivator
extends HousekeepingActivator {
    private volatile OSGIFileStorageServiceRegistry registry;
    private volatile OSGIFileStorageAccountManagerLookupService lookupService;

    protected Class<?>[] getNeededServices() {
        return new Class[]{ConfigurationService.class};
    }

    protected void startBundle() throws Exception {
        Logger log = LoggerFactory.getLogger(FileStorageActivator.class);
        try {
            log.info("starting bundle: com.openexchange.file.storage");
            Services.setServices((ServiceLookup)this);
            OSGIFileStorageServiceRegistry registry = new OSGIFileStorageServiceRegistry();
            registry.start(this.context);
            this.registry = registry;
            OSGIFileStorageAccountManagerLookupService lookupService = new OSGIFileStorageAccountManagerLookupService();
            lookupService.start(this.context);
            this.lookupService = lookupService;
            this.trackService(SecretService.class);
            this.openTrackers();
            this.registerService(FileStorageServiceRegistry.class, registry);
            this.registerService(FileStorageAccountManagerLookupService.class, lookupService);
            this.registerService(QuotaProvider.class, new FileStorageQuotaProvider(registry));
            this.registerService(Reloadable.class, FileStorageConfigReloadable.getInstance());
        }
        catch (Exception e) {
            log.error("Starting bundle \"com.openexchange.file.storage\" failed.", (Throwable)e);
            throw e;
        }
    }

    public void stopBundle() throws Exception {
        Logger log = LoggerFactory.getLogger(FileStorageActivator.class);
        try {
            OSGIFileStorageServiceRegistry registry;
            log.info("stopping bundle: com.openexchange.file.storage");
            this.unregisterServices();
            OSGIFileStorageAccountManagerLookupService lookupService = this.lookupService;
            if (null != lookupService) {
                lookupService.stop();
                this.lookupService = null;
            }
            if (null != (registry = this.registry)) {
                registry.stop();
                this.registry = null;
            }
            Services.setServices(null);
            super.stopBundle();
        }
        catch (Exception e) {
            log.error("Stopping bundle \"com.openexchange.file.storage\" failed.", (Throwable)e);
            throw e;
        }
    }
}

