/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.config.ConfigurationService;
import com.openexchange.config.Reloadable;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.internal.FileStorageConfigReloadable;
import com.openexchange.file.storage.osgi.Services;
import com.openexchange.java.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileStorageUtility {
    private static final Pattern IS_NUMBERED_WITH_EXTENSION = Pattern.compile("\\(\\d+\\)\\.");
    private static final Pattern IS_NUMBERED = Pattern.compile("\\(\\d+\\)$");
    private static volatile Integer numberOfPregeneratedPreviews;
    private static volatile Long threshold;
    private static volatile Integer compressionLevel;

    private FileStorageUtility() {
    }

    public static String getETagFor(File fileMetadata) {
        return FileStorageUtility.getETagFor(fileMetadata.getId(), fileMetadata.getVersion(), fileMetadata.getLastModified());
    }

    public static String getETagFor(String id, String version, Date lastModified) {
        StringBuilder sb = new StringBuilder("http://www.open-xchange.com/infostore");
        if (null != id) {
            sb.append('/').append(id);
        }
        if (null != version) {
            sb.append('/').append(version);
        }
        if (null != lastModified) {
            sb.append('/').append(lastModified.getTime());
        }
        return sb.toString();
    }

    public static void checkUrl(File file) throws OXException {
        FileStorageUtility.checkUrl(file.getURL());
    }

    public static void checkUrl(String sUrl) throws OXException {
        if (Strings.isEmpty((String)sUrl)) {
            return;
        }
        try {
            URL url = new URL(sUrl);
            String protocol = url.getProtocol();
            if (!"http".equals(protocol) && !"https".equals(protocol)) {
                throw new MalformedURLException("Only http & https protocols supported.");
            }
        }
        catch (MalformedURLException e) {
            throw FileStorageExceptionCodes.INVALID_URL.create(e, sUrl, e.getMessage());
        }
    }

    public static String enhance(String filename, int counter) {
        if (null == filename) {
            return filename;
        }
        String counterString = '(' + String.valueOf(counter) + ')';
        Matcher matcher = IS_NUMBERED_WITH_EXTENSION.matcher(filename);
        if (matcher.find()) {
            return new StringBuilder(filename).replace(matcher.start(), matcher.end() - 1, counterString).toString();
        }
        matcher = IS_NUMBERED.matcher(filename);
        if (matcher.find()) {
            return new StringBuilder(filename).replace(matcher.start(), matcher.end(), counterString).toString();
        }
        int index = filename.lastIndexOf(46);
        if (filename.endsWith(".pgp") && (index = filename.substring(0, filename.length() - 4).lastIndexOf(46)) != filename.lastIndexOf(46)) {
            return new StringBuilder(filename).insert(index, ' ' + counterString).toString();
        }
        if (0 >= index) {
            index = filename.length();
        }
        return new StringBuilder(filename).insert(index, ' ' + counterString).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getNumberOfPregeneratedPreviews() {
        Integer tmp = numberOfPregeneratedPreviews;
        if (null != tmp) return tmp;
        Class<FileStorageUtility> clazz = FileStorageUtility.class;
        synchronized (FileStorageUtility.class) {
            tmp = numberOfPregeneratedPreviews;
            if (null != tmp) return tmp;
            int defaultNumberOfPregeneratedPreviews = 20;
            ConfigurationService service = Services.getOptionalService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultNumberOfPregeneratedPreviews;
            }
            numberOfPregeneratedPreviews = tmp = Integer.valueOf(service.getIntProperty("com.openexchange.file.storage.numberOfPregeneratedPreviews", defaultNumberOfPregeneratedPreviews));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long threshold() {
        Long tmp = threshold;
        if (null != tmp) return tmp;
        Class<FileStorageUtility> clazz = FileStorageUtility.class;
        synchronized (FileStorageUtility.class) {
            tmp = threshold;
            if (null != tmp) return tmp;
            long defaultThreshold = 0x40000000L;
            ConfigurationService service = Services.getOptionalService(ConfigurationService.class);
            if (null == service) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return defaultThreshold;
            }
            String property = service.getProperty("com.openexchange.file.storage.zipFolderThreshold");
            threshold = tmp = null == property ? Long.valueOf(defaultThreshold) : Long.valueOf(property.trim());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getZipDocumentsCompressionLevel() throws OXException {
        Integer tmp = compressionLevel;
        if (null != tmp) return tmp;
        Class<FileStorageUtility> clazz = FileStorageUtility.class;
        synchronized (FileStorageUtility.class) {
            tmp = compressionLevel;
            if (null != tmp) return tmp;
            ConfigurationService configService = Services.getOptionalService(ConfigurationService.class);
            if (null == configService) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return -1;
            }
            int level = configService.getIntProperty("com.openexchange.infostore.zipDocumentsCompressionLevel", -1);
            if (level < -1 || level > 9) {
                throw FileStorageExceptionCodes.UNEXPECTED_ERROR.create("Invalid configuration for property 'com.openexchange.infostore.zipDocumentsCompressionLevel'");
            }
            compressionLevel = tmp = Integer.valueOf(level);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return tmp;
        }
    }

    static {
        FileStorageConfigReloadable.getInstance().addReloadable(new Reloadable(){

            public void reloadConfiguration(ConfigurationService configService) {
                numberOfPregeneratedPreviews = null;
                threshold = null;
                compressionLevel = null;
            }

            public Map<String, String[]> getConfigFileNames() {
                return null;
            }
        });
    }
}

