/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.session.Session;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import org.osgi.service.event.Event;

public class FileStorageEventHelper {
    public static Event buildUpdateEvent(Session session, String service, String accountId, String folderId, String objectId, String optFileName, EventProperty ... properties) {
        return new Event("com/openexchange/groupware/infostore/update", FileStorageEventHelper.buildProperties(session, service, accountId, folderId, objectId, optFileName, properties));
    }

    public static Event buildCreateEvent(Session session, String service, String accountId, String folderId, String objectId, String optFileName, EventProperty ... properties) {
        return new Event("com/openexchange/groupware/infostore/insert", FileStorageEventHelper.buildProperties(session, service, accountId, folderId, objectId, optFileName, properties));
    }

    public static Event buildDeleteEvent(Session session, String service, String accountId, String folderId, String objectId, String optFileName, Set<String> versions, EventProperty ... properties) {
        Dictionary<String, Object> props = FileStorageEventHelper.buildProperties(session, service, accountId, folderId, objectId, optFileName, properties);
        if (versions != null) {
            props.put("versions", versions);
        }
        return new Event("com/openexchange/groupware/infostore/delete", props);
    }

    public static Event buildAccessEvent(Session session, String service, String accountId, String folderId, String objectId, String optFileName, EventProperty ... properties) {
        return new Event("com/openexchange/groupware/infostore/access", FileStorageEventHelper.buildProperties(session, service, accountId, folderId, objectId, optFileName, properties));
    }

    private static Dictionary<String, Object> buildProperties(Session session, String service, String accountId, String folderId, String objectId, String optFileName, EventProperty ... properties) {
        Hashtable<String, Object> ht = new Hashtable<String, Object>(8);
        if (null != session) {
            ((Dictionary)ht).put("session", session);
        }
        if (null != service) {
            ((Dictionary)ht).put("service", service);
        }
        if (null != accountId) {
            ((Dictionary)ht).put("accountId", accountId);
        }
        if (null != objectId) {
            ((Dictionary)ht).put("objectId", objectId);
            ((Dictionary)ht).put("eTag", FileStorageUtility.getETagFor(objectId, FileStorageFileAccess.CURRENT_VERSION, null));
        }
        if (null != folderId) {
            ((Dictionary)ht).put("folderId", folderId);
        }
        if (null != optFileName) {
            ((Dictionary)ht).put("fileName", optFileName);
        }
        if (null != properties && 0 != properties.length) {
            for (EventProperty property : properties) {
                if (property == null) continue;
                ((Dictionary)ht).put(property.getKey(), property.getValue());
            }
        }
        return ht;
    }

    public static boolean isCreateEvent(Event event) {
        return "com/openexchange/groupware/infostore/insert".equals(event.getTopic());
    }

    public static boolean isUpdateEvent(Event event) {
        return "com/openexchange/groupware/infostore/update".equals(event.getTopic());
    }

    public static boolean isDeleteEvent(Event event) {
        return "com/openexchange/groupware/infostore/delete".equals(event.getTopic());
    }

    public static boolean isInfostoreEvent(Event event) {
        return "com.openexchange.infostore".equals(event.getProperty("service"));
    }

    public static Session extractSession(Event event) throws OXException {
        Object sessionObj = event.getProperty("session");
        if (sessionObj == null) {
            throw FileStorageExceptionCodes.MISSING_PARAMETER.create("session");
        }
        if (!(sessionObj instanceof Session)) {
            throw FileStorageExceptionCodes.INVALID_PARAMETER.create("session", sessionObj.getClass().getName());
        }
        return (Session)sessionObj;
    }

    public static String extractObjectId(Event event) throws OXException {
        return FileStorageEventHelper.extractValue(event, "objectId");
    }

    public static String extractFolderId(Event event) throws OXException {
        return FileStorageEventHelper.extractValue(event, "folderId");
    }

    public static String extractAccountId(Event event) throws OXException {
        return FileStorageEventHelper.extractValue(event, "accountId");
    }

    public static String extractService(Event event) throws OXException {
        return FileStorageEventHelper.extractValue(event, "service");
    }

    public static Set<String> extractVersions(Event event) {
        Object versionsObj = event.getProperty("versions");
        if (versionsObj == null || !(versionsObj instanceof Set)) {
            return null;
        }
        return (Set)versionsObj;
    }

    public static String createDebugMessage(String eventName, Event event) {
        StringBuilder sb = new StringBuilder("Received ");
        sb.append(eventName);
        sb.append(": ");
        sb.append(event.toString());
        for (String key : event.getPropertyNames()) {
            Object value = event.getProperty(key);
            sb.append("\n    ");
            sb.append(key);
            sb.append(": ");
            if ("folderPath".equals(key) && Object[].class.isInstance(value)) {
                sb.append(Arrays.toString((Object[])value));
                continue;
            }
            sb.append(value);
        }
        return sb.toString();
    }

    private static String extractValue(Event event, String key) throws OXException {
        Object obj = event.getProperty(key);
        if (obj == null) {
            throw FileStorageExceptionCodes.MISSING_PARAMETER.create(key);
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw FileStorageExceptionCodes.INVALID_PARAMETER.create(key, obj.getClass().getName(), String.class.getName());
    }

    public static final class EventProperty {
        private final String key;
        private final Object value;

        public EventProperty(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("Argument 'key' must not be null!");
            }
            if (value == null) {
                throw new IllegalArgumentException("Argument 'value' must not be null!");
            }
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventProperty other = (EventProperty)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }
}

