/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.infostore.internal;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.infostore.osgi.Services;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderResponse;
import com.openexchange.folderstorage.FolderService;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.Type;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.type.TrashType;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreFacade;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.search.ComparablePattern;
import com.openexchange.groupware.infostore.search.ComparisonType;
import com.openexchange.groupware.infostore.search.LastModifiedUtcTerm;
import com.openexchange.groupware.infostore.search.SearchTerm;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.java.util.TimeZones;
import com.openexchange.session.Session;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrashCleaner
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TrashCleaner.class);
    private final ServerSession session;
    private final Date maxLastModified;
    private FolderService folderService;

    public TrashCleaner(ServerSession session, int retentionDays) {
        this.session = session;
        this.maxLastModified = TrashCleaner.getMaxLastModified(retentionDays);
    }

    private FolderService getFolderService() {
        if (null == this.folderService) {
            this.folderService = Services.getService(FolderService.class);
        }
        return this.folderService;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        int deletedFiles = 0;
        int deletedFolders = 0;
        LOG.debug("{} starting, purging items older than {}.", (Object)this, (Object)this.maxLastModified);
        try {
            UserizedFolder trashFolder = this.getTrashFolder();
            if (null == trashFolder) {
                LOG.debug("No default trash folder found for user {} in context {}, aborting.", (Object)this.session.getUserId(), (Object)this.session.getContextId());
                return;
            }
            deletedFiles = this.cleanupFiles(trashFolder);
            deletedFolders = this.cleanupFolders(trashFolder);
        }
        catch (Exception e) {
            LOG.warn("Unexpected error during trash cleanup run for user {} in context {}:", new Object[]{this.session.getUserId(), this.session.getContextId(), e.getMessage(), e});
        }
        LOG.debug("{} finished after {}ms, purged {} folders and {} files.", new Object[]{this, System.currentTimeMillis() - start, deletedFolders, deletedFiles});
    }

    private int cleanupFolders(UserizedFolder folder) throws OXException {
        List<UserizedFolder> deletableFolders = this.getDeletableFolders(folder);
        if (0 == deletableFolders.size()) {
            return 0;
        }
        FolderServiceDecorator decorator = new FolderServiceDecorator().put("hardDelete", (Object)Boolean.TRUE.toString());
        for (UserizedFolder deletableFolder : deletableFolders) {
            this.getFolderService().deleteFolder(FolderStorage.REAL_TREE_ID, deletableFolder.getID(), folder.getLastModifiedUTC(), (Session)this.session, decorator);
        }
        return deletableFolders.size();
    }

    private List<UserizedFolder> getDeletableFolders(UserizedFolder parentFolder) throws OXException {
        UserizedFolder[] subfolders;
        String[] subfolderIDs = parentFolder.getSubfolderIDs();
        if (null == subfolderIDs || 0 == subfolderIDs.length) {
            return Collections.emptyList();
        }
        ArrayList<UserizedFolder> deletableFolders = new ArrayList<UserizedFolder>();
        FolderResponse folderResponse = this.getFolderService().getSubfolders(FolderStorage.REAL_TREE_ID, parentFolder.getID(), true, (Session)this.session, null);
        if (null != folderResponse && null != (subfolders = (UserizedFolder[])folderResponse.getResponse()) && 0 < subfolders.length) {
            for (UserizedFolder folder : subfolders) {
                if (null == folder.getLastModifiedUTC() || !this.maxLastModified.after(folder.getLastModifiedUTC())) continue;
                deletableFolders.add(folder);
            }
        }
        return deletableFolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cleanupFiles(UserizedFolder folder) throws OXException {
        SearchIterator<DocumentMetadata> searchIterator = null;
        long sequenceNumber = 0L;
        ArrayList<FileStorageFileAccess.IDTuple> deletableDocuments = new ArrayList<FileStorageFileAccess.IDTuple>();
        try {
            searchIterator = this.searchDeletableFiles(folder);
            while (searchIterator.hasNext()) {
                DocumentMetadata document = (DocumentMetadata)searchIterator.next();
                if (null == document.getLastModified() || !this.maxLastModified.after(document.getLastModified())) continue;
                deletableDocuments.add(new FileStorageFileAccess.IDTuple(folder.getID(), String.valueOf(document.getId())));
                sequenceNumber = Math.max(sequenceNumber, document.getSequenceNumber());
            }
        }
        finally {
            SearchIterators.close(searchIterator);
        }
        if (0 < deletableDocuments.size()) {
            InfostoreFacade infostore = Services.getService(InfostoreFacade.class);
            List notRemoved = infostore.removeDocument(deletableDocuments, sequenceNumber, this.session);
            if (null != notRemoved && 0 < notRemoved.size()) {
                LOG.debug("Failed to cleanup the following files for user {} in context {}: {}", new Object[]{this.session.getUserId(), this.session.getContext(), notRemoved});
                return deletableDocuments.size() - notRemoved.size();
            }
            return deletableDocuments.size();
        }
        return 0;
    }

    private SearchIterator<DocumentMetadata> searchDeletableFiles(UserizedFolder folder) throws OXException {
        int[] folderIDs = new int[]{Integer.parseInt(folder.getID())};
        SearchTerm<?> searchTerm = this.buildSearchTerm();
        Metadata[] columns = new Metadata[]{Metadata.LAST_MODIFIED_LITERAL, Metadata.ID_LITERAL, Metadata.SEQUENCE_NUMBER_LITERAL};
        InfostoreSearchEngine searchEngine = Services.getService(InfostoreSearchEngine.class);
        return searchEngine.search(this.session, searchTerm, folderIDs, columns, null, -11, -11, -11);
    }

    private SearchTerm<?> buildSearchTerm() {
        return new LastModifiedUtcTerm((ComparablePattern)new ComparablePattern<Date>(){

            public ComparisonType getComparisonType() {
                return ComparisonType.LESS_THAN;
            }

            public Date getPattern() {
                return TrashCleaner.this.maxLastModified;
            }
        });
    }

    private UserizedFolder getTrashFolder() throws OXException {
        try {
            return this.getFolderService().getDefaultFolder(this.session.getUser(), FolderStorage.REAL_TREE_ID, (ContentType)InfostoreContentType.getInstance(), (Type)TrashType.getInstance(), (Session)this.session, null);
        }
        catch (OXException e) {
            if (!FolderExceptionErrorMessage.NO_DEFAULT_FOLDER.equals(e)) {
                throw e;
            }
            return null;
        }
    }

    private static Date getMaxLastModified(int retentionDays) {
        Calendar calendar = Calendar.getInstance(TimeZones.UTC);
        calendar.add(6, -1 * retentionDays);
        return calendar.getTime();
    }

    public String toString() {
        return "TrashCleaner [user=" + this.session.getUserId() + ", context=" + this.session.getContextId() + "]";
    }
}

