/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.mbean;

import com.openexchange.config.Reloadable;
import com.openexchange.config.internal.ConfigurationImpl;
import com.openexchange.config.mbean.ConfigReloadMBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigReloadMBeanImpl
extends StandardMBean
implements ConfigReloadMBean {
    private final ConfigurationImpl configService;

    public ConfigReloadMBeanImpl(Class<? extends ConfigReloadMBean> mbeanInterface, ConfigurationImpl configService) throws NotCompliantMBeanException {
        super(mbeanInterface);
        this.configService = configService;
    }

    @Override
    public void reloadConfiguration() throws MBeanException {
        Logger logger = LoggerFactory.getLogger(ConfigReloadMBeanImpl.class);
        try {
            ConfigurationImpl configService = this.configService;
            if (null != configService) {
                configService.reloadConfiguration();
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }

    @Override
    public Map<String, List<String>> listReloadables() throws MBeanException {
        Logger logger = LoggerFactory.getLogger(ConfigReloadMBeanImpl.class);
        try {
            ConfigurationImpl configService = this.configService;
            if (null == configService) {
                return Collections.emptyMap();
            }
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            Iterator<Reloadable> i = configService.getReloadables().iterator();
            while (i.hasNext()) {
                Map<String, String[]> configs = i.next().getConfigFileNames();
                if (null == configs || configs.isEmpty()) continue;
                for (Map.Entry<String, String[]> fileEntry : configs.entrySet()) {
                    map.put(fileEntry.getKey(), Arrays.asList((Object[])fileEntry.getValue()));
                }
            }
            return map;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            String message = e.getMessage();
            throw new MBeanException(new Exception(message), message);
        }
    }
}

