/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config;

import com.openexchange.config.ConfigurationService;
import com.openexchange.tools.strings.TimeSpanParser;

public class ConfigTools {
    private static final String NON_PERSISTENT_IDENTIFIER = "web-browser";
    private static final int NON_PERSISTENT_VALUE = -1;

    public static int parseTimespanSecs(String span) {
        if (null == span) {
            return -1;
        }
        String tmp = span.trim();
        if (NON_PERSISTENT_IDENTIFIER.equals(tmp.toLowerCase())) {
            return -1;
        }
        return (int)(TimeSpanParser.parseTimespan((String)tmp) / 1000L);
    }

    public static long parseTimespan(String span) {
        if (null == span) {
            return -1L;
        }
        String tmp = span.trim();
        if (NON_PERSISTENT_IDENTIFIER.equals(tmp.toLowerCase())) {
            return -1L;
        }
        return TimeSpanParser.parseTimespan((String)tmp);
    }

    public static long getLongProperty(String name, long defaultValue, ConfigurationService service) {
        if (null == service) {
            return defaultValue;
        }
        String property = service.getProperty(name);
        if (null == property) {
            return defaultValue;
        }
        try {
            return Long.parseLong(property.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

