/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.task;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.webdav.xml.GroupUserTest;
import com.openexchange.webdav.xml.TaskTest;
import java.util.Date;
import java.util.Locale;

public class UpdateTest
extends TaskTest {
    public UpdateTest(String name) {
        super(name);
    }

    public void testUpdateTask() throws Exception {
        Task taskObj = this.createTask("testUpdateTask");
        int objectId = UpdateTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        taskObj = this.createTask("testUpdateTask2");
        taskObj.setNote(null);
        UpdateTest.updateTask(this.webCon, taskObj, objectId, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        UpdateTest.deleteTask(this.getWebConversation(), objectId, this.taskFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateTaskRemoveAlarm() throws Exception {
        Task taskObj = this.createTask("testUpdateTaskRemoveAlarm");
        taskObj.setAlarm(new Date(this.startTime.getTime() - 172800000L));
        int objectId = UpdateTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        taskObj = this.createTask("testUpdateTaskRemoveAlarm2");
        taskObj.setNote(null);
        taskObj.setAlarmFlag(false);
        UpdateTest.updateTask(this.webCon, taskObj, objectId, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Task loadTask = UpdateTest.loadTask(this.getWebConversation(), objectId, this.taskFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        UpdateTest.compareObject(taskObj, loadTask);
        UpdateTest.deleteTask(this.getWebConversation(), objectId, this.taskFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateTaskWithParticipants() throws Exception {
        Task taskObj = this.createTask("testUpdateTask");
        int objectId = UpdateTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        taskObj = this.createTask("testUpdateTask");
        int userParticipantId = GroupUserTest.getUserId(this.getWebConversation(), "http://" + this.getHostName(), this.userParticipant3, this.getPassword(), this.context);
        UpdateTest.assertTrue((String)"user participant not found", (userParticipantId != -1 ? 1 : 0) != 0);
        Group[] groupArray = GroupUserTest.searchGroup(this.webCon, this.groupParticipant, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
        UpdateTest.assertTrue((String)"group array size is not > 0", (groupArray.length > 0 ? 1 : 0) != 0);
        int groupParticipantId = groupArray[0].getIdentifier();
        Participant[] participants = new Participant[2];
        participants[0] = new UserParticipant();
        participants[0].setIdentifier(userParticipantId);
        participants[1] = new GroupParticipant(groupParticipantId);
        taskObj.setParticipants(participants);
        UpdateTest.updateTask(this.webCon, taskObj, objectId, this.taskFolderId, "http://" + this.hostName, this.login, this.password, this.context);
        Task loadTask = UpdateTest.loadTask(this.getWebConversation(), objectId, this.taskFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        UpdateTest.compareObject(taskObj, loadTask);
        UpdateTest.deleteTask(this.getWebConversation(), objectId, this.taskFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testUpdateConcurentConflict() throws Exception {
        Task taskObj = this.createTask("testUpdateTaskConcurentConflict");
        int objectId = UpdateTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        taskObj = this.createTask("testUpdateTaskConcurentConflict2");
        try {
            UpdateTest.updateTask(this.webCon, taskObj, objectId, this.taskFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            UpdateTest.fail((String)"expected concurent modification exception!");
        }
        catch (OXException exc) {
            UpdateTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1000);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.taskFolderId}};
        UpdateTest.deleteTask(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testUpdateNotFound() throws Exception {
        Task taskObj = this.createTask("testUpdateTaskNotFound");
        int objectId = UpdateTest.insertTask(this.webCon, taskObj, "http://" + this.hostName, this.login, this.password, this.context);
        taskObj = this.createTask("testUpdateTaskNotFound2");
        try {
            UpdateTest.updateTask(this.webCon, taskObj, objectId + 1000, this.taskFolderId, new Date(0L), "http://" + this.hostName, this.login, this.password, this.context);
            UpdateTest.fail((String)"expected object not found exception!");
        }
        catch (OXException exc) {
            UpdateTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), 1001);
        }
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.taskFolderId}};
        UpdateTest.deleteTask(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }
}

