/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.webdav.AbstractWebDAVSession;
import com.openexchange.webdav.xml.XmlServlet;
import com.openexchange.webdav.xml.appointment.actions.InsertRequest;
import com.openexchange.webdav.xml.appointment.actions.InsertResponse;
import com.openexchange.webdav.xml.framework.WebDAVClient;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Bug12338Test
extends AbstractWebDAVSession {
    private static final Logger LOG = LoggerFactory.getLogger(Bug12338Test.class);

    public Bug12338Test(String name) {
        super(name);
    }

    public void testStrangeExternal() throws Throwable {
        WebDAVClient client = this.getClient();
        FolderObject folder = client.getFolderTools().getDefaultAppointmentFolder();
        TimeZone tz = TimeZone.getTimeZone("Europe/Berlin");
        Calendar calendar = Calendar.getInstance(tz);
        calendar.set(11, 12);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Appointment appointment = new Appointment();
        appointment.setTitle("Test appointment for bug 12338");
        appointment.setParentFolderID(folder.getObjectID());
        appointment.setStartDate(calendar.getTime());
        calendar.add(10, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.setIgnoreConflicts(true);
        appointment.setParticipants(new Participant[]{new UserParticipant(client.getGroupUserTools().getUserId()), new ExternalUserParticipant("/O=COMPARIS/OU=FIRST ADMINISTRATIVE GROUP/CN=RECIPIENTS/CN=Johann.burkhard")});
        SpecialInsertRequest request = new SpecialInsertRequest(appointment, client.getGroupUserTools().getUserId());
        InsertResponse response = client.execute(request);
        response.fillObject((DataObject)appointment);
        LOG.info("Identifier: " + appointment.getObjectID());
        LOG.info("Timestamp: " + appointment.getLastModified());
    }

    private class SpecialInsertRequest
    extends InsertRequest {
        private final int userId;

        public SpecialInsertRequest(Appointment appointment, int userId) {
            super(appointment);
            this.userId = userId;
        }

        @Override
        protected Element createProp() throws OXException, IOException {
            Element eProp = super.createProp();
            eProp.removeChild("participants", XmlServlet.NS);
            Element participants = new Element("participants", XmlServlet.NS);
            eProp.addContent((Content)participants);
            Element user1 = new Element("user", this.createNS());
            participants.addContent((Content)user1);
            user1.addNamespaceDeclaration(this.createNS());
            user1.setAttribute("displayname", "comparis.ch - Ralf Beyeler", this.createNS());
            user1.addNamespaceDeclaration(this.createNS());
            user1.setAttribute("external", "true", this.createNS());
            user1.addNamespaceDeclaration(this.createNS());
            user1.setAttribute("confirm", "none", this.createNS());
            user1.setText("/O=COMPARIS/OU=FIRST ADMINISTRATIVE GROUP/CN=RECIPIENTS/CN=Ralf.beyeler");
            Element user2 = new Element("user", this.createNS());
            participants.addContent((Content)user2);
            user2.setAttribute("external", "false", XmlServlet.NS);
            user2.setAttribute("confirm", "accept", XmlServlet.NS);
            user2.setText(String.valueOf(this.userId));
            return eProp;
        }

        private final Namespace createNS() {
            return Namespace.getNamespace((String)"ox", (String)"http://www.open-xchange.org");
        }
    }
}

