/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.java.Charsets;
import com.openexchange.webdav.action.ActionTestCase;
import com.openexchange.webdav.action.MockWebdavRequest;
import com.openexchange.webdav.action.MockWebdavResponse;
import com.openexchange.webdav.action.WebdavPropfindAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.Protocol;
import com.openexchange.webdav.protocol.WebdavCollection;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;

public class Bug34283Test
extends ActionTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        WebdavCollection collection = this.factory.resolveCollection(this.testCollection);
        for (int i = 0; i < 30; ++i) {
            byte[] bytes = UUID.randomUUID().toString().getBytes(Charsets.UTF_8);
            WebdavResource resource = collection.resolveResource(new WebdavPath((CharSequence)("child_" + i + ".test")));
            resource.setContentType("text/html");
            resource.putBodyAndGuessLength((InputStream)new ByteArrayInputStream(bytes));
            resource.create();
        }
    }

    public void testMarshallingLimit() throws Exception {
        MockWebdavRequest request = new MockWebdavRequest(this.factory, "http://localhost/");
        request.setBodyAsString("<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:displayname/></D:prop></D:propfind>");
        request.setHeader("depth", "1");
        request.setUrl(this.testCollection);
        MockWebdavResponse response = new MockWebdavResponse();
        Protocol protocol = new Protocol(){

            public int getRecursiveMarshallingLimit() {
                return 25;
            }
        };
        new WebdavPropfindAction(protocol).perform((WebdavRequest)request, (WebdavResponse)response);
        Bug34283Test.assertEquals((String)"Wrong response status", (int)207, (int)response.getStatus());
        Bug34283Test.assertTrue((String)"No HTTP 507 in response", (boolean)response.getResponseBodyAsString().contains("HTTP/1.1 507"));
    }
}

