/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user;

import com.openexchange.authentication.SessionEnhancement;
import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.TestServiceRegistry;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.AddSessionParameter;
import com.openexchange.sessiond.SessiondService;
import com.openexchange.test.AjaxInit;
import com.openexchange.test.TestInit;
import com.openexchange.user.UserService;
import java.util.Date;
import java.util.UUID;
import junit.framework.TestCase;

public class Bug36228Test
extends TestCase {
    private static boolean init;
    private final String NEW_NAME = "testBug36228";
    private UserService us;
    private ContactService cs;
    private Context context;
    private User user;
    private Contact contact;
    private String oldName;

    public void setUp() throws Exception {
        super.setUp();
        TestInit.loadTestProperties();
        if (!init) {
            Init.startServer();
            init = true;
        }
        this.us = TestServiceRegistry.getInstance().getService(UserService.class);
        this.cs = TestServiceRegistry.getInstance().getService(ContactService.class);
        String contextName = AjaxInit.getAJAXProperty("contextName");
        this.context = ContextStorage.getStorageContext((int)this.getContextId(contextName));
        String login = AjaxInit.getAJAXProperty("login");
        int userId = this.getUserId(login);
        this.user = UserStorage.getInstance().getUser(userId, this.context);
    }

    public void tearDown() throws Exception {
        if (null != this.oldName) {
            Contact update = new Contact();
            update.setSurName(this.oldName);
            this.cs.updateUser(this.createSession(this.user, this.context), String.valueOf(6), String.valueOf(this.contact.getObjectID()), update, new Date());
        }
        super.tearDown();
    }

    public void testBug36228() throws Exception {
        Session session = this.createSession(this.user, this.context);
        this.contact = this.cs.getUser(session, this.user.getId());
        this.oldName = this.contact.getSurName();
        Contact update = new Contact();
        update.setSurName("testBug36228");
        this.cs.updateUser(session, String.valueOf(6), String.valueOf(this.contact.getObjectID()), update, new Date());
        User u = this.us.getUser(this.user.getId(), this.context);
        Contact loaded = this.cs.getContact(session, String.valueOf(6), String.valueOf(u.getContactId()));
        Bug36228Test.assertEquals((String)"", (String)"testBug36228", (String)loaded.getSurName());
    }

    private int getContextId(String login) throws OXException {
        int ctxId = -1;
        int pos = login.indexOf("@");
        String ctxName = login.substring(pos + 1);
        ctxId = ContextStorage.getInstance().getContextId(ctxName);
        return ctxId;
    }

    private int getUserId(String login) throws OXException {
        int userId = -1;
        int pos = login.indexOf("@");
        if (pos > -1) {
            String userName = login.substring(0, pos);
            userId = UserStorage.getInstance().getUserId(userName, this.context);
        } else {
            userId = UserStorage.getInstance().getUserId(login, this.context);
        }
        return userId;
    }

    private Session createSession(final User u, final Context c) throws OXException {
        SessiondService sessiondService = TestServiceRegistry.getInstance().getService(SessiondService.class);
        return sessiondService.addSession(new AddSessionParameter(){

            public boolean isTransient() {
                return false;
            }

            public String getUserLoginInfo() {
                return u.getLoginInfo();
            }

            public int getUserId() {
                return u.getId();
            }

            public String getPassword() {
                return "";
            }

            public String getHash() {
                return u.getDisplayName() + "hash";
            }

            public String getFullLogin() {
                return u.getLoginInfo() + "@" + c.getName();
            }

            public Context getContext() {
                return c;
            }

            public String getClientToken() {
                return "UnittestToken";
            }

            public String getClientIP() {
                return "localhost";
            }

            public String getClient() {
                return "Unittest";
            }

            public String getAuthId() {
                return UUID.randomUUID().toString();
            }

            public SessionEnhancement getEnhancement() {
                return null;
            }
        });
    }
}

