/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.filestore.QuotaFileStorage;
import com.openexchange.filestore.impl.LocalFileStorage;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.java.Autoboxing;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class InMemoryFileStorage
extends LocalFileStorage
implements QuotaFileStorage {
    private final Map<Context, Map<String, byte[]>> data = new HashMap<Context, Map<String, byte[]>>();
    private final Map<Context, List<String>> deletions = new HashMap<Context, List<String>>();
    private Context ctx;

    protected Set<String> delete(String[] names) {
        for (String name : names) {
            this.getCtxMap().put(name, null);
            this.deletions.get(this.ctx).add(name);
        }
        return Collections.emptySet();
    }

    protected void save(String name, InputStream input) throws OXException {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        byte[] buffer = new byte[1024];
        int length = -1;
        try {
            while ((length = input.read(buffer)) != -1) {
                for (int i = 0; i < length; ++i) {
                    bytes.add(Autoboxing.B((byte)buffer[i]));
                }
            }
        }
        catch (IOException e) {
            throw new OXException((Throwable)e);
        }
        byte[] tmpData = new byte[bytes.size()];
        int i = 0;
        Iterator i$ = bytes.iterator();
        while (i$.hasNext()) {
            byte b = (Byte)i$.next();
            tmpData[i++] = b;
        }
        this.put(name, tmpData);
    }

    protected InputStream load(String name) {
        byte[] bytes = this.get(name);
        if (bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(bytes);
    }

    public InputStream getFile(String name) throws OXException {
        return this.load(name);
    }

    protected boolean exists(String name) {
        return this.getCtxMap().containsKey(name);
    }

    protected void eliminate() {
        this.data.clear();
        this.deletions.clear();
    }

    protected void lock(long timeout) {
    }

    protected void unlock() {
    }

    public SortedSet<String> getFileList() {
        TreeSet<String> retval = new TreeSet<String>();
        retval.addAll(this.getCtxMap().keySet());
        retval.removeAll(SPECIAL_FILENAMES);
        return retval;
    }

    public long getFileSize(String name) {
        return this.get(name).length;
    }

    public void put(Context context, String filestoreId, byte[] bytes) {
        this.getCtxMap(context).put(filestoreId, bytes);
    }

    public void setContext(Context ctx) {
        this.ctx = ctx;
    }

    private Map<String, byte[]> getCtxMap(Context context) {
        if (this.data.containsKey(context)) {
            return this.data.get(context);
        }
        HashMap<String, byte[]> fileData = new HashMap<String, byte[]>();
        this.data.put(context, fileData);
        return fileData;
    }

    private Map<String, byte[]> getCtxMap() {
        return this.getCtxMap(this.ctx);
    }

    private byte[] get(String name) {
        return this.getCtxMap().get(name);
    }

    private void put(String name, byte[] bytes) {
        this.getCtxMap().put(name, bytes);
    }

    public void forgetDeleted(Context context) {
        this.deletions.put(context, new ArrayList());
    }

    public List<String> getDeleted(Context context) {
        return this.deletions.get(context);
    }

    public URI getUri() {
        return null;
    }

    public long getQuota() {
        return 0L;
    }

    public long getUsage() throws OXException {
        return 0L;
    }

    public void recalculateUsage() throws OXException {
    }

    public void recalculateUsage(Set<String> filesToIgnore) throws OXException {
    }

    public String saveNewFile(InputStream file, long sizeHint) throws OXException {
        return null;
    }

    public long appendToFile(InputStream file, String name, long offset, long sizeHint) throws OXException {
        return 0L;
    }
}

