/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.filestore.impl.LocalFileStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.TreeSet;
import junit.framework.TestCase;

public class FileStorageThreadTest
extends TestCase {
    private final FMRunner[] fmr = new FMRunner[5];
    private final Thread[] thread = new Thread[this.fmr.length];
    static File tempFile;

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        tempFile = File.createTempFile("filestorage", ".tmp");
        tempFile.delete();
        new LocalFileStorage(tempFile.toURI());
        for (i = 0; i < this.fmr.length; ++i) {
            this.fmr[i] = new FMRunner();
            this.thread[i] = new Thread(this.fmr[i]);
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].start();
        }
    }

    public void tearDown() throws Exception {
        int i;
        for (i = 0; i < this.fmr.length; ++i) {
            this.fmr[i].stop();
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].join();
        }
        for (i = 0; i < this.fmr.length; ++i) {
            if (this.fmr[i].getThrowable() == null) continue;
            FileStorageThreadTest.fail((String)this.fmr[i].getThrowable().getMessage());
        }
        LocalFileStorage fm = new LocalFileStorage(tempFile.toURI());
        FileStorageThreadTest.assertTrue((String)"State file is not correct.", (boolean)fm.stateFileIsCorrect());
        FileStorageThreadTest.rmdir(new File("file:" + tempFile.toString()));
        super.tearDown();
    }

    private static void rmdir(File dir) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                FileStorageThreadTest.rmdir(f);
            }
        }
        dir.delete();
    }

    public void testStateFileIsCorrect() throws Throwable {
        File testfile = File.createTempFile("filestorage", ".test");
        LocalFileStorage fm = new LocalFileStorage(tempFile.toURI());
        TreeSet<String> set = new TreeSet<String>();
        for (int j = 0; j < 10; ++j) {
            for (int i = 0; i < 10; ++i) {
                FileInputStream is = new FileInputStream(testfile);
                String str = fm.saveNewFile((InputStream)is);
                set.add(str);
                System.out.println("Thread: " + Thread.currentThread().getName() + ", speichern: " + str);
                ((InputStream)is).close();
            }
            for (int k = 0; k < 10; k += 3) {
                System.out.println("Thread: " + Thread.currentThread().getName() + ", speichern: " + fm.deleteFile((String)set.first()));
                set.remove(set.first());
            }
        }
        FileStorageThreadTest.rmdir(testfile);
    }

    private static final class FMRunner
    implements Runnable {
        private boolean run = true;
        private Throwable t;

        FMRunner() {
        }

        void stop() {
            this.run = false;
        }

        Throwable getThrowable() {
            return this.t;
        }

        @Override
        public void run() {
            try {
                File testfile = File.createTempFile("filestorage", ".test");
                LocalFileStorage fm = new LocalFileStorage(tempFile.toURI());
                TreeSet<String> set = new TreeSet<String>();
                while (this.run) {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        FileInputStream is = new FileInputStream(testfile);
                        String str = fm.saveNewFile((InputStream)is);
                        ((InputStream)is).close();
                        set.add(str);
                        System.out.println("Thread: " + Thread.currentThread().getName() + ", speichern: " + str);
                    }
                    for (i = 0; i < 10; i += 3) {
                        boolean del = fm.deleteFile((String)set.first());
                        set.remove(set.first());
                        System.out.println("Thread: " + Thread.currentThread().getName() + ", l\u00f6schen: " + del);
                    }
                }
                testfile.delete();
            }
            catch (Throwable t2) {
                this.t = t2;
            }
        }
    }
}

