/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.google;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.subscribe.google.GoogleSubscribeTestEnvironment;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class AbstractGoogleSubscribeTest
extends AbstractAJAXSession {
    private CalendarTestManager calendarMgr;
    private ContactTestManager contactMgr;
    private FolderTestManager folderMgr;

    protected AbstractGoogleSubscribeTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.calendarMgr = new CalendarTestManager(this.client);
        this.contactMgr = new ContactTestManager(this.client);
        this.folderMgr = new FolderTestManager(this.client);
    }

    public CalendarTestManager getCalendarManager() {
        return this.calendarMgr;
    }

    public ContactTestManager getContactManager() {
        return this.contactMgr;
    }

    public FolderTestManager getFolderManager() {
        return this.folderMgr;
    }

    public static void assertFieldIsNull(String fieldDesc, Object valueToCheck) {
        AbstractGoogleSubscribeTest.assertNull((String)("The field " + fieldDesc + " should be empty, but is not "), (Object)valueToCheck);
    }

    public static void assertNotNullAndEquals(String fieldDesc, Object expected, Object actual) {
        AbstractGoogleSubscribeTest.assertNotNull((String)("Could not find expected mapping for " + fieldDesc), (Object)actual);
        AbstractGoogleSubscribeTest.assertEquals((String)("Mapping for field '" + fieldDesc + "' differs -->"), (Object)expected, (Object)actual);
    }

    public static void assertFieldNotNull(String fieldDesc, Object expected, Object actual) {
        AbstractGoogleSubscribeTest.assertNotNull((String)("Could not find expected mapping for " + fieldDesc), (Object)actual);
    }

    protected Date getDateTime(int day, int month, int year, int hour, int minute) {
        return this.getDateTime(day, month, year, hour, minute, 0, TimeZone.getTimeZone("Europe/Berlin"));
    }

    protected Date getDateTime(int day, int month, int year, int hour, int minute, int seconds) {
        return this.getDateTime(day, month, year, hour, minute, seconds, TimeZone.getTimeZone("Europe/Berlin"));
    }

    protected Date getDateTime(int day, int month, int year, int hour, int minute, int seconds, TimeZone timezone) {
        Calendar cal = Calendar.getInstance(timezone);
        cal.clear();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        cal.set(10, hour);
        cal.set(12, minute);
        cal.set(13, seconds);
        return cal.getTime();
    }

    private int getTestFolderID(String id) {
        return GoogleSubscribeTestEnvironment.getInstance().getTestFolders().get(id);
    }

    protected int getCalendarTestFolderID() {
        return this.getTestFolderID("com.openexchange.subscribe.google.calendar");
    }

    protected int getContactTestFolderID() {
        return this.getTestFolderID("com.openexchange.subscribe.google.contact");
    }
}

