/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONObject;

public class SMIMEStructureTest
extends AbstractMailTest {
    public SMIMEStructureTest() {
    }

    public SMIMEStructureTest(String name) {
        super(name);
    }

    public void testAnotherMIMEStructure() {
        try {
            this.getSession();
            byte[] smime = "From: \"Jane Doe\" <jane@spoof.de>\nTo: <barfoo@trub.org>\nSubject: SMIME\nDate: Thu, 30 Jun 2011 11:40:19 +0200\nMessage-ID: <000233b01cc3709$ba120c00$2e362400$@de>\nMIME-Version: 1.0\nContent-Language: de\nContent-Type: multipart/signed;\n    protocol=\"application/x-pkcs7-signature\";\n    micalg=MD5;\n    boundary=\"----=_NextPart_000_0003_01CC371A.78F2B0B0\"\n\nThis is a multi-part message in MIME format.\n\n------=_NextPart_000_0003_01CC371A.78F2B0B0\nContent-Type: multipart/related;\n    boundary=\"----=_NextPart_001_0004_01CC371A.78F2B0B0\"\n\n\n------=_NextPart_001_0004_01CC371A.78F2B0B0\nContent-Type: multipart/alternative;\n    boundary=\"----=_NextPart_002_0005_01CC371A.78F2D7C0\"\n\n\n------=_NextPart_002_0005_01CC371A.78F2D7C0\nContent-Type: text/plain;\n    charset=\"UTF-8\"\nContent-Transfer-Encoding: quoted-printable\n\nHallo Peter Pan,\n\n=20\n\nblah blah blah.\n\n\n------=_NextPart_002_0005_01CC371A.78F2D7C0\nContent-Type: text/html;\n    charset=\"UTF-8\"\nContent-Transfer-Encoding: quoted-printable\n\n<html xmlns:v=3D\"urn:schemas-microsoft-com:vml\" =\nxmlns:o=3D\"urn:schemas-microsoft-com:office:office\" =\nxmlns:w=3D\"urn:schemas-microsoft-com:office:word\" =\nxmlns:m=3D\"http://schemas.microsoft.com/office/2004/12/omml\" =\nxmlns=3D\"http://www.w3.org/TR/REC-html40\"><head><meta http-equiv=3DContent-Type content=3D\"text/html; charset=3Dutf-8\">\n</head><body lang=3DDE link=3Dblue =\nvlink=3Dpurple><div class=3DWordSection1><p class=3DMsoNormal>Hallo =\nDirk,<o:p></o:p></p><p class=3DMsoNormal><o:p>&nbsp;</o:p></p><p =\nclass=3DMsoNormal>blah blah blah. =\n<o:p></o:p></p><p =\nclass=3DMsoNormal><o:p>&nbsp;</o:p></p><p =\n</body></html>\n------=_NextPart_002_0005_01CC371A.78F2D7C0--\n\n------=_NextPart_001_0004_01CC371A.78F2B0B0\nContent-Type: image/jpeg;\n    name=\"image001.jpg\"\nContent-Transfer-Encoding: base64\nContent-ID: <image001.jpg@01CC371A.78CBEED0>\n\n/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAVQAA/+4ADkFkb2JlAGTAAAAAAf/b\nAIQAAgEBAQEBAgEBAgMCAQIDAwICAgIDAwMDAwMDAwQDBAQEBAMEBAUGBgYFBAcHCAgHBwoKCgoK\nBoA0AaANAGgDQBoA0AaANAGgDQBoA0AaANAYLf4B/l+U3+J8vw/tfw+/QAr8C/L8wfP/AE/Z/H7t\nAZ6ANAay/Mb4fH7Pj8pfm/j/AFaA+pfAfh8w/L8PmH/z9+gM9AGgDQBoDQl/7Kvyf2Pl+f4D839W\nheCN+hA0B//Z\n\n------=_NextPart_001_0004_01CC371A.78F2B0B0\nContent-Type: image/jpeg;\n    name=\"image002.jpg\"\nContent-Transfer-Encoding: base64\nContent-ID: <image002.jpg@01CC371A.78CBEED0>\n\n/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAVQAA/+4ADkFkb2JlAGTAAAAAAf/b\nAIQAAgEBAQEBAgEBAgMCAQIDAwICAgIDAwMDAwMDAwQDBAQEBAMEBAUGBgYFBAcHCAgHBwoKCgoK\n/i3vJvoLx36yL1o/RGfi5SePGO8HwtQ4rLMnGC2vqvwRWHlVZtobzHiyrjy3yzl2ZTZwY4DuoPaO\n5em2wZuLC3G2Babb0Yv+K8p6jy87KzJ3eSEhfLbt0dhpECLxAi30s1KiqIOr60i//9k=\n\n------=_NextPart_001_0004_01CC371A.78F2B0B0--\n\n------=_NextPart_000_0003_01CC371A.78F2B0B0\nContent-Type: application/x-pkcs7-signature;\n    name=\"smime.p7s\"\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment;\n    filename=\"smime.p7s\"\n\nMIAGCSqGSIb3DQEHAqCAMIACAQExDjAMBggqhkiG9w0CBQUAMIAGCSqGSIb3DQEHAQAAoIISdjCC\nA58wggKHoAMCAQICASYwDQYJKoZIhvcNAQEFBQAwcTELMAkGA1UEBhMCREUxHDAaBgNVBAoTE0Rl\n+143qlXSfnnnWFAgjCePzaRpl6nzl/WUqBNWldF9POxRqhTnuze1Kt06AyfqxK2Z8fX8FUj8h5Tj\nsYOMGi8yNP9Ik5fjuUeLWSoVPnor3rE5YW68xyY79VLOb2pLIqMsF7x0XXkGVn31AAAAAAAA\n\n------=_NextPart_000_0003_01CC371A.78F2B0B0--\n\n".getBytes();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])smime);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            SMIMEStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            SMIMEStructureTest.assertTrue((String)"Detected a body object, but shouldn't be there.", (!jsonMailObject.hasAndNotNull("body") ? 1 : 0) != 0);
            SMIMEStructureTest.assertTrue((String)"Missing S/MIME body text.", (boolean)jsonMailObject.hasAndNotNull("smime_body_text"));
            SMIMEStructureTest.assertTrue((String)"Missing S/MIME body data.", (boolean)jsonMailObject.hasAndNotNull("smime_body_data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            SMIMEStructureTest.fail((String)e.getMessage());
        }
    }

    public void testYetAnotherMIMEStructure2() {
        try {
            this.getSession();
            byte[] smime = "From: asdsad@gmx.de\nContent-Type: multipart/signed; boundary=\"Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350\"; protocol=\"application/pkcs7-signature\"; micalg=sha1\nDate: Wed, 14 May 2014 08:56:15 -0400\nSubject: My subject\nTo: hgjjgh@open-xchange.com\nMessage-Id: <7029863B-C54D-403B-B29C-9BAFD00E0DBABE@gmx.de>\nMime-Version: 1.0 (Mac OS X Mail 7.2 \\(1874\\))\nX-Mailer: Apple Mail (2.1874)\n\n\n--Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350\nContent-Transfer-Encoding: 7bit\nContent-Type: text/plain;\n    charset=us-ascii\n\nHi stefan\n;)\nstefan\n--Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350\nContent-Disposition: attachment;\n    filename=smime.p7s\nContent-Type: application/pkcs7-signature;\n    name=smime.p7s\nContent-Transfer-Encoding: base64\n\nMIAGCSqGSIb3DQEHAqCAMIACAQExCzAJBgUrDgMCGgUAMIAGCSqGSIb3DQEHAQAAoIIO2TCCBIow\nggNyoAMCAQICECf06hH0eobEbp27bqkXBwcwDQYJKoZIhvcNAQEFBQAwbzELMAkGA1UEBhMCU0Ux\nFDASBgNVBAoTC0FkZFRydXN0IEFCMSYwJAYDVQQLEx1BZGRUcnVzdCBFeHRlcm5hbCBUVFAgTmV0\nGTppEtDs5R1PU3gYbpis78Ay9ZhjHpmM7ip3IX+PAGqsO3K7ASfZk68yeqpyuBy8mr3jA4cbymMh\npAHl6SOzA2VJqEhh+CxDWfBlzdMm3v/JXAIE4WJAUhiD7XW3lqX1O2RBTwLHUypPAx3/8B1to6Gn\nBvjl9VXHCRRbimvMR6+mRXJaXdyF9Q8kyBtQ1YQMpgPln+C5svwRQK5znMMDow6ky6zCnVPvx6TA\ndRqQbotPXRhJYf2hYV62t5QMZuz4Y7fHB6k6+VVdhC1Kms3J1YxnQX52Fr7HQcOgKeRKvluug2wV\nEkJjJDoENHQAAAAAAAA=\n\n--Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350--\n".getBytes();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])smime);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            SMIMEStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            SMIMEStructureTest.assertTrue((String)"Detected a body object, but shouldn't be there.", (!jsonMailObject.hasAndNotNull("body") ? 1 : 0) != 0);
            SMIMEStructureTest.assertTrue((String)"Missing S/MIME body text.", (boolean)jsonMailObject.hasAndNotNull("smime_body_text"));
            SMIMEStructureTest.assertTrue((String)"Missing S/MIME body data.", (boolean)jsonMailObject.hasAndNotNull("smime_body_data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            SMIMEStructureTest.fail((String)e.getMessage());
        }
    }

    public void testYetAnotherMIMEStructure() {
        try {
            this.getSession();
            byte[] smime = "From: sadsr@dsa.nl\nContent-Type: multipart/signed; boundary=\"Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350\"; protocol=\"application/pkcs7-signature\"; micalg=sha1\nDate: Wed, 14 May 2014 08:56:15 -0400\nSubject: F G H J\nTo: asdd@dsa.nl>\nMessage-Id: <7029863B-C54D-403B-B29C-9BD00E0DBABE@gmx.de>\nMime-Version: 1.0\n\n--Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350\nContent-Transfer-Encoding: 7bit\nContent-Type: text/plain;\n    charset=us-ascii\n\nHi Asdfg\n;)\ndsfgh\n--Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350\nContent-Disposition: attachment;\n    filename=smime.p7s\nContent-Type: application/pkcs7-signature;\n    name=smime.p7s\nContent-Transfer-Encoding: base64\n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\nEkJjJDoENHQAAAAAAAA=\n\n--Apple-Mail=_7F65DE4D-4C06-49D2-BFA0-63F9B3D3E350--\n".getBytes();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])smime);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            SMIMEStructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            SMIMEStructureTest.assertTrue((String)"Detected a body object, but shouldn't be there.", (!jsonMailObject.hasAndNotNull("body") ? 1 : 0) != 0);
            SMIMEStructureTest.assertTrue((String)"Missing S/MIME body text.", (boolean)jsonMailObject.hasAndNotNull("smime_body_text"));
            SMIMEStructureTest.assertTrue((String)"Missing S/MIME body data.", (boolean)jsonMailObject.hasAndNotNull("smime_body_data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            SMIMEStructureTest.fail((String)e.getMessage());
        }
    }
}

