/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.mail.internet.MimeMessage;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug29227_StructureTest
extends AbstractMailTest {
    public Bug29227_StructureTest() {
    }

    public Bug29227_StructureTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            ByteArrayInputStream is = new ByteArrayInputStream("From: Thomas Siedentopf <thomas.siedentopf@open-xchange.com>\nMessage-Id: <78C422B9-380A-4A65-BF83-EFE1D82BE266@open-xchange.com>\nDate: Thu, 10 Oct 2013 16:54:40 +0200\nTo: \"usm-internal@open-xchange.com\" <usm-internal@open-xchange.com>\nMime-Version: 1.0 (Mac OS X Mail 6.6 \\(1510\\))\nX-Mailer: Apple Mail (2.1510)\nX-purgate-ID: 151428::1381416880-0000781E-F10036FE/0-0/0-0\nX-purgate-type: clean\nX-purgate-size: 880\nX-purgate-Ad: Categorized by eleven eXpurgate (R) http://www.eleven.de\nX-Notice: Whitelisted\nX-purgate: This mail is considered clean (visit http://www.eleven.de for\n    further information)\nX-purgate: clean\nSubject: [Usm-internal] Displayname in EAS\nX-BeenThere: usm-internal@open-xchange.com\nX-Mailman-Version: 2.1.11\nPrecedence: list\nReply-To: usm-internal@open-xchange.com\nList-Id: \"Mailinglist: USM related coordination\"\n    <usm-internal.open-xchange.com>\nList-Unsubscribe: <https://lists-int.open-xchange.com/mailman/options/usm-internal>,\n    <mailto:usm-internal-request@open-xchange.com?subject=unsubscribe>\nList-Archive: <http://lists-int.open-xchange.com/pipermail/usm-internal>\nList-Post: <mailto:usm-internal@open-xchange.com>\nList-Help: <mailto:usm-internal-request@open-xchange.com?subject=help>\nList-Subscribe: <https://lists-int.open-xchange.com/mailman/listinfo/usm-internal>,\n    <mailto:usm-internal-request@open-xchange.com?subject=subscribe>\nContent-Type: multipart/mixed; boundary=\"===============1069459393==\"\nSender: usm-internal-bounces@open-xchange.com\nErrors-To: usm-internal-bounces@open-xchange.com\n\n\n--===============1069459393==\nContent-Type: multipart/signed; boundary=\"Apple-Mail=_A3CDE761-6E8C-4EF6-813D-04E4A348F283\"; protocol=\"application/pgp-signature\"; micalg=pgp-sha1\n\n\n--Apple-Mail=_A3CDE761-6E8C-4EF6-813D-04E4A348F283\nContent-Transfer-Encoding: quoted-printable\nContent-Type: text/plain;\n    charset=windows-1252\n\nHi,\n\nsimple question - which name should be displayed in a From: Field of a =\nmail that was send over by an EAS client?\n\nE-Mail Address?\nDisplayname?\nName Surname?\n=85?\n\nThomas\n\n--Apple-Mail=_A3CDE761-6E8C-4EF6-813D-04E4A348F283\nContent-Transfer-Encoding: 7bit\nContent-Disposition: attachment;\n    filename=signature.asc\nContent-Type: application/pgp-signature;\n    name=signature.asc\nContent-Description: Message signed with OpenPGP using GPGMail\n\n-----BEGIN PGP SIGNATURE-----\nComment: GPGTools - http://gpgtools.org\n\niEYEARECAAYFAlJWv7AACgkQdERBopHyS4M0tQCgngPOOZwVZBSazGKlZhrb4Xer\nRXAAnjefwajmiOSQHyVLXNxSbD/0ZfbH\n=Zvzy\n-----END PGP SIGNATURE-----\n\n--Apple-Mail=_A3CDE761-6E8C-4EF6-813D-04E4A348F283--\n\n--===============1069459393==\nContent-Type: text/plain; charset=\"us-ascii\"\nMIME-Version: 1.0\nContent-Transfer-Encoding: 7bit\nContent-Disposition: inline\n\n_______________________________________________\nusm-internal mailing list\nusm-internal@open-xchange.com\nhttps://lists-int.open-xchange.com/mailman/listinfo/usm-internal\n\n--===============1069459393==--".getBytes());
            MimeMessage mimeMessage = new MimeMessage(MimeDefaultSession.getDefaultSession(), (InputStream)is);
            MailMessage mail = MimeMessageConverter.convertMessage((MimeMessage)mimeMessage);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().setParseTNEFParts(true).parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            Bug29227_StructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            JSONArray bodies = jsonMailObject.optJSONArray("body");
            Bug29227_StructureTest.assertNotNull((String)"Structured JSON mail object has no body party.", (Object)bodies);
            Bug29227_StructureTest.assertEquals((String)"Unexpected number of body parts", (int)2, (int)bodies.length());
            JSONObject signed = bodies.optJSONObject(0);
            Bug29227_StructureTest.assertNotNull((String)"Missing multipart/signed part.", (Object)signed);
            JSONArray signedBodies = signed.optJSONArray("body");
            Bug29227_StructureTest.assertNotNull((String)"SignedJSON mail object has no body party.", (Object)signedBodies);
            Bug29227_StructureTest.assertEquals((String)"Unexpected number of signed body parts", (int)2, (int)signedBodies.length());
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug29227_StructureTest.fail((String)e.getMessage());
        }
    }
}

