/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.structure;

import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.structure.StructureHandler;
import com.openexchange.mail.structure.StructureMailMessageParser;
import com.openexchange.mail.structure.handler.MIMEStructureHandler;
import org.json.JSONObject;

public class Bug16174StructureTest
extends AbstractMailTest {
    private static final byte[] SIMPLE = "From: postmaster@integralis.com\nTo: martin.kauss@open-xchange.com\nDate: May 21, 2010 12:11:08 PM CEST\nMIME-Version: 1.0\nSubject: Test\nContent-Type: text/plain; charset=UTF-8\n\nThis is a text message.\n\n".getBytes();

    public Bug16174StructureTest() {
    }

    public Bug16174StructureTest(String name) {
        super(name);
    }

    public void testMIMEStructure() {
        try {
            this.getSession();
            MailMessage mail = MimeMessageConverter.convertMessage((byte[])SIMPLE);
            MIMEStructureHandler handler = new MIMEStructureHandler(-1L);
            new StructureMailMessageParser().parseMailMessage(mail, (StructureHandler)handler);
            JSONObject jsonMailObject = handler.getJSONMailObject();
            Bug16174StructureTest.assertNotNull((String)"Structured JSON mail object is null.", (Object)jsonMailObject);
            Object bodyObject = jsonMailObject.opt("body");
            Bug16174StructureTest.assertNotNull((String)"Missing mail body.", (Object)bodyObject);
            Bug16174StructureTest.assertTrue((String)"Body object is not a JSON object.", (boolean)(bodyObject instanceof JSONObject));
            JSONObject jsonBodyObject = (JSONObject)bodyObject;
            Bug16174StructureTest.assertTrue((String)"Missing \"data\" key.", (boolean)jsonBodyObject.hasAndNotNull("data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Bug16174StructureTest.fail((String)e.getMessage());
        }
    }
}

