/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail;

import com.openexchange.exception.OXException;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailField;
import com.openexchange.mail.MailSortField;
import com.openexchange.mail.OrderDirection;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.DumperMessageHandler;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;

public final class MailLogicToolsTest
extends AbstractMailTest {
    private static final String TEST_MAIL = "Return-Path: <tobias.prinz@open-xchange.com>\r\nReceived: from ox.netline-is.de ([unix socket]) by ox (Cyrus v2.2.3) with LMTP; Wed, 15 Aug 2007 14:03:12 +0200\r\nX-Sieve: CMU Sieve 2.2\r\nReceived: by ox.netline-is.de (Postfix, from userid 65534) id 5073F318173; Wed, 15 Aug 2007 14:03:12 +0200 (CEST)\r\nReceived: from netline.de (comfire.netline.de [192.168.32.1]) by ox.netline-is.de (Postfix) with ESMTP id 494D531816D for <thorben@open-xchange.com>; Wed, 15 Aug 2007 14:03:11 +0200 (CEST)\r\nReceived: from [10.20.30.11] (helo=www.open-xchange.org ident=mail) by netline.de with esmtp (Exim) id 1ILHV0-00063Y-00 for thorben@open-xchange.com; Wed, 15 Aug 2007 13:57:18 +0200\r\nReceived: from mail.open-xchange.com ([10.20.30.22] helo=ox.open-xchange.com) by www.open-xchange.org with esmtp (Exim 3.36 #1 (Debian)) id 1ILHZi-0004x6-00 for <thorben@open-xchange.org>; Wed, 15 Aug 2007 14:02:10 +0200\r\nReceived: by ox.open-xchange.com (Postfix, from userid 76) id 469A532CDE6; Wed, 15 Aug 2007 14:02:05 +0200 (CEST)\r\nReceived: from ox.open-xchange.com ([unix socket]) by ox.open-xchange.com (Cyrus v2.2.12-Invoca-RPM-2.2.12-8.1.RHEL4) with LMTPA; Wed, 15 Aug 2007 14:02:05 +0200\r\nX-Sieve: CMU Sieve 2.2\r\nReceived: by ox.open-xchange.com (Postfix, from userid 99) id F0DBC32CDE4; Wed, 15 Aug 2007 14:02:04 +0200 (CEST)\r\nReceived: from oxee (unknown [192.168.32.9]) by ox.open-xchange.com (Postfix) with ESMTP id E5C4332C84D; Wed, 15 Aug 2007 14:02:03 +0200 (CEST)\r\nDate: Wed, 15 Aug 2007 14:01:20 +0200 (CEST)r\nFrom: \"Prinz, Tobias\" <tobias.prinz@open-xchange.com>\r\nReply-To: \"Prinz, Tobias\" <tobias.prinz@open-xchange.com>\r\nTo: Thorben <thorben.betten@open-xchange.com>, Betten@ox.open-xchange.com\r\nMessage-ID: <9692463.1901187179280437.JavaMail.open-xchange@oxee>\r\nSubject: Bug 8844: Kannst Du den Patch mal probieren?\r\nMIME-Version: 1.0\r\nContent-Type: multipart/mixed; boundary=\"----=_Part_73_20070782.1187179280395\"\r\nX-Priority: 3\r\nX-Mailer: Open-Xchange Mailer v6.3.0-6270\r\nX-Spam-Checker-Version: SpamAssassin 2.64 (2004-01-11) on ox.netline-is.de\r\nX-Spam-Level: \r\nX-Spam-Status: No, hits=-4.8 required=5.0 tests=AWL,BAYES_00 autolearn=ham version=2.64\r\n\r\n------=_Part_73_20070782.1187179280395\r\nMIME-Version: 1.0\r\nContent-Type: text/plain; charset=UTF-8\r\nContent-Transfer-Encoding: 7bit\r\n\r\nBitte vorher CVS auschecken oder wenigstens die com.openexchange.tools.versit.old.OldNPropertyDefinition aktualisieren.\r\n\r\n-- \r\nTobias Prinz, Developer\r\nPhone +49 2761 - 83 85 21\r\nFax +49 2761 - 83 85 30\r\nMobil + 49 160 - 91 40 80 95\r\nOpen-Xchange GmbH, Martinstr. 41, D-57462 Olpe\r\nAG N&uuml;rnberg, HRB 22121\r\nGesch&auml;ftsf&uuml;hrer: Frank Hoberg, Martin Kauss\r\n------=_Part_73_20070782.1187179280395\r\nContent-Type: text/plain\r\nContent-Transfer-Encoding: 7bit\r\nContent-Disposition: attachment; filename=patch-8844.txt\r\n\r\n### Eclipse Workspace Patch 1.0\r\n#P osr-openexchange-HEAD\r\nIndex: src/com/openexchange/groupware/container/mail/filler/MessageFiller.java\r\n===================================================================\r\nRCS file: /var/lib/cvs/open-xchange/src/com/openexchange/groupware/container/mail/filler/MessageFiller.java,v\r\nretrieving revision 1.31\r\ndiff -u -r1.31 MessageFiller.java\r\n--- src/com/openexchange/groupware/container/mail/filler/MessageFiller.java\t14 Aug 2007 14:56:14 -0000\t1.31\r\n+++ src/com/openexchange/groupware/container/mail/filler/MessageFiller.java\t15 Aug 2007 11:59:54 -0000\r\n@@ -140,7 +140,7 @@\r\n \r\nprivate static final String MIME_MESSAGE_RFC822 = \"message/rfc822\";\r\n \r\n-\tprivate static final String MIME_TEXT_VCARD = \"text/vcard\";\r\n+\tprivate static final String MIME_TEXT_VCARD = \"text/x-vcard\";\r\n \r\nprivate static final String MIME_TEXT_PLAIN = \"text/plain\";\r\n \r\n@@ -898,7 +898,7 @@\r\n} catch (final Exception e) {\r\nthrow new OXMailException(MailCode.INTERNAL_ERROR, e, e.getMessage());\r\n}\r\n-\t\t\tfinal VersitObject versitObj = converter.convertContact(contactObj, \"3.0\");\r\n+\t\t\tfinal VersitObject versitObj = converter.convertContact(contactObj, \"2.1\");\r\nfinal ByteArrayOutputStream os = new ByteArrayOutputStream();\r\nfinal VersitDefinition def = Versit.getDefinition(MIME_TEXT_VCARD);\r\nfinal VersitDefinition.Writer w = def.getWriter(os, IMAPProperties.getDefaultMimeCharset());\r\n\r\n------=_Part_73_20070782.1187179280395\r\nMIME-Version: 1.0\r\nContent-Type: text/vcard; charset=us-ascii; name=\"Prinz,Tobias.vcf\"\r\nContent-Transfer-Encoding: 7bit\r\nContent-Disposition: attachment; filename=\"Prinz,Tobias.vcf\"\r\n\r\nBEGIN:VCARD\r\nVERSION:3.0\r\nPRODID:OPEN-XCHANGE\r\nFN:Prinz\\, Tobias\r\nN:Prinz;Tobias;;;\r\nNICKNAME:Tierlieb\r\nBDAY:19810501\r\nADR;TYPE=work:;;;Meinerzhagen;NRW;58540;DE\r\nTEL;TYPE=home,voice:+49 2358 7192\r\nEMAIL:tobias.prinz@open-xchange.com\r\nORG:- deactivated -\r\nREV:20061204T160750.018Z\r\nURL:www.tobias-prinz.de\r\nUID:80@oxee.netline.de\r\nEND:VCARD\r\n\r\n------=_Part_73_20070782.1187179280395--";
    private static final MailField[] COMMON_LIST_FIELDS = new MailField[]{MailField.ID, MailField.FOLDER_ID, MailField.FROM, MailField.TO, MailField.RECEIVED_DATE, MailField.SENT_DATE, MailField.SUBJECT, MailField.CONTENT_TYPE, MailField.FLAGS, MailField.PRIORITY, MailField.COLOR_LABEL};

    public MailLogicToolsTest() {
    }

    public MailLogicToolsTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testForward() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailAccess = MailAccess.getInstance((Session)session);
            mailAccess.connect();
            try {
                MailMessage[] mails = mailAccess.getMessageStorage().searchMessages("INBOX", null, MailSortField.RECEIVED_DATE, OrderDirection.DESC, null, COMMON_LIST_FIELDS);
                int count = 0;
                for (int i = 0; i < mails.length; ++i) {
                    if (!mails[i].getContentType().isMimeType("multipart/mixed")) continue;
                    DumperMessageHandler msgHandler1 = new DumperMessageHandler(false);
                    new MailMessageParser().parseMailMessage(mailAccess.getMessageStorage().getMessage("INBOX", mails[i].getMailId(), true), (MailMessageHandler)msgHandler1);
                    MailMessage[] ms = new MailMessage[]{mailAccess.getMessageStorage().getMessage("INBOX", mails[i].getMailId(), false)};
                    MailMessage forwardMail = mailAccess.getLogicTools().getFowardMessage(ms, false);
                    DumperMessageHandler msgHandler = new DumperMessageHandler(false);
                    new MailMessageParser().parseMailMessage(forwardMail, (MailMessageHandler)msgHandler);
                    if (++count != 50) continue;
                    break;
                }
            }
            finally {
                mailAccess.close(true);
            }
        }
        catch (OXException e) {
            e.printStackTrace();
            MailLogicToolsTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReply() {
        try {
            SessionObject session = this.getSession();
            MailAccess mailConnection = MailAccess.getInstance((Session)session);
            mailConnection.connect();
            try {
                MailMessage[] mails = mailConnection.getMessageStorage().searchMessages("INBOX", null, MailSortField.RECEIVED_DATE, OrderDirection.DESC, null, COMMON_LIST_FIELDS);
                int count = 0;
                for (int i = 0; i < mails.length; ++i) {
                    if (!"11611".equals(mails[i].getMailId())) continue;
                    DumperMessageHandler msgHandler1 = new DumperMessageHandler(true);
                    new MailMessageParser().parseMailMessage(mailConnection.getMessageStorage().getMessage("default/INBOX", mails[i].getMailId(), true), (MailMessageHandler)msgHandler1);
                    MailMessage originalMail = mailConnection.getMessageStorage().getMessage("INBOX", mails[i].getMailId(), false);
                    MailMessage replyMail = mailConnection.getLogicTools().getReplyMessage(originalMail, true);
                    DumperMessageHandler msgHandler = new DumperMessageHandler(true);
                    new MailMessageParser().parseMailMessage(replyMail, (MailMessageHandler)msgHandler);
                    if (++count != 50) continue;
                    break;
                }
            }
            finally {
                mailConnection.close(true);
            }
        }
        catch (OXException e) {
            e.printStackTrace();
            MailLogicToolsTest.fail((String)e.getMessage());
        }
    }
}

