/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.json;

import com.openexchange.json.OXJSONWriter;
import junit.framework.TestCase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONWriterTest
extends TestCase {
    public void testEmptyObject() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            json.object();
            json.endObject();
            JSONWriterTest.assertEquals((String)"{}", (String)json.getObject().toString());
        }
        catch (JSONException e) {
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testObjectWithScalars() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            json.object();
            json.key("string");
            json.value((Object)"String");
            json.key("integer");
            json.value(23L);
            json.key("float");
            json.value(3.14);
            json.key("boolean");
            json.value(true);
            json.endObject();
            JSONObject object = (JSONObject)json.getObject();
            JSONWriterTest.assertEquals((String)"String", (String)object.optString("string"));
            JSONWriterTest.assertEquals((long)23L, (long)object.optLong("integer"));
            JSONWriterTest.assertEquals((Object)3.14, (Object)object.optDouble("float"));
            JSONWriterTest.assertTrue((boolean)object.optBoolean("boolean"));
        }
        catch (JSONException e) {
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testEmptyArray() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            json.array();
            json.endArray();
            JSONWriterTest.assertEquals((String)"[]", (String)json.getObject().toString());
        }
        catch (JSONException e) {
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testArrayWithScalars() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            json.array();
            json.value((Object)"string");
            json.value(23L);
            json.value(3.14);
            json.value(true);
            json.endArray();
            JSONArray arr = (JSONArray)json.getObject();
            JSONWriterTest.assertEquals((String)"string", (String)arr.getString(0));
            JSONWriterTest.assertEquals((long)23L, (long)arr.getLong(1));
            JSONWriterTest.assertEquals((Object)3.14, (Object)arr.getDouble(2));
            JSONWriterTest.assertTrue((boolean)arr.getBoolean(3));
        }
        catch (JSONException e) {
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testObjectWithObjects() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            json.object();
            json.key("object1");
            json.object();
            json.key("first");
            json.value((Object)"Tester");
            json.key("last");
            json.value((Object)"von Testingen");
            json.endObject();
            json.key("object2");
            json.object();
            json.key("first");
            json.value((Object)"Testerine");
            json.key("last");
            json.value((Object)"von Testeringen");
            json.endObject();
            json.endObject();
            JSONObject object = json.isJSONObject() ? (JSONObject)json.getObject() : null;
            JSONObject object1 = object.getJSONObject("object1");
            JSONObject object2 = object.getJSONObject("object2");
            JSONWriterTest.assertEquals((String)"Tester", (String)object1.optString("first"));
            JSONWriterTest.assertEquals((String)"von Testingen", (String)object1.optString("last"));
            JSONWriterTest.assertEquals((String)"Testerine", (String)object2.optString("first"));
            JSONWriterTest.assertEquals((String)"von Testeringen", (String)object2.optString("last"));
        }
        catch (JSONException e) {
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testObjectWithArrays() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            json.object();
            json.key("array1");
            json.array();
            json.value((Object)"Tester");
            json.value((Object)"von Testingen");
            json.endArray();
            json.key("array2");
            json.array();
            json.value((Object)"Testerine");
            json.value((Object)"von Testeringen");
            json.endArray();
            json.endObject();
            JSONObject object = (JSONObject)json.getObject();
            JSONArray arr1 = object.getJSONArray("array1");
            JSONArray arr2 = object.getJSONArray("array2");
            JSONWriterTest.assertEquals((String)"Tester", (String)arr1.getString(0));
            JSONWriterTest.assertEquals((String)"von Testingen", (String)arr1.getString(1));
            JSONWriterTest.assertEquals((String)"Testerine", (String)arr2.getString(0));
            JSONWriterTest.assertEquals((String)"von Testeringen", (String)arr2.getString(1));
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testArrayWithObjects() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            json.array();
            json.object();
            json.key("first");
            json.value((Object)"Tester");
            json.key("last");
            json.value((Object)"von Testingen");
            json.endObject();
            json.object();
            json.key("first");
            json.value((Object)"Testerine");
            json.key("last");
            json.value((Object)"von Testeringen");
            json.endObject();
            json.endArray();
            JSONArray arr = (JSONArray)json.getObject();
            JSONObject object1 = arr.getJSONObject(0);
            JSONObject object2 = arr.getJSONObject(1);
            JSONWriterTest.assertEquals((String)"Tester", (String)object1.optString("first"));
            JSONWriterTest.assertEquals((String)"von Testingen", (String)object1.optString("last"));
            JSONWriterTest.assertEquals((String)"Testerine", (String)object2.optString("first"));
            JSONWriterTest.assertEquals((String)"von Testeringen", (String)object2.optString("last"));
        }
        catch (JSONException e) {
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testDeepLevelObjects() {
        OXJSONWriter json = new OXJSONWriter();
        try {
            int i;
            json.array();
            json.object().key("level-key" + String.valueOf(0));
            json.value((Object)("level-val" + String.valueOf(0))).endObject();
            int level = 20;
            for (i = 0; i < 20; ++i) {
                json.object().key("level-key" + String.valueOf(i + 1));
            }
            json.value((Object)"thevalue");
            for (i = 19; i >= 0; --i) {
                json.endObject();
            }
            json.object().key("first1").object().key("second1").object().key("third1").value((Object)"dasd").endObject().key("asasasas").value((Object)"sdfsdfsdf").endObject().endObject();
            json.endArray();
            json.getObject().toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testArrayInitializedWriter() {
        JSONArray ja = new JSONArray().put((Object)"Value01").put((Object)"Value02");
        try {
            OXJSONWriter json = new OXJSONWriter(ja);
            json.array().value((Object)"Foo").value((Object)"Bar").endArray();
            json.value((Object)"Value03");
            json.endArray();
            JSONWriterTest.assertEquals((String)ja.toString(), (String)json.getObject().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testObjectInitializedWriter() {
        try {
            JSONObject jo = new JSONObject().put("Key01", (Object)"Value01").put("Key02", (Object)"Value02");
            OXJSONWriter json = new OXJSONWriter(jo);
            json.key("InnerArr");
            json.array().value((Object)"Foo").value((Object)"Bar").endArray();
            json.key("Key03").value((Object)"Value03");
            json.endObject();
            JSONWriterTest.assertEquals((String)jo.toString(), (String)json.getObject().toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
            JSONWriterTest.fail((String)e.getMessage());
        }
    }

    public void testComplex() {
    }

    public void testInvalid() {
    }
}

