/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.extensions;

import com.openexchange.groupware.settings.extensions.ServicePublisher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MockServiceRegistry
implements ServicePublisher {
    private final Map<Class, List> services = new HashMap<Class, List>();
    private final Map<Class, List> added = new HashMap<Class, List>();
    private final Map<Class, List> removed = new HashMap<Class, List>();

    public void publishService(Class clazz, Object service) {
        if (!clazz.isAssignableFrom(service.getClass())) {
            throw new IllegalArgumentException("The service is not a " + clazz);
        }
        this.getAllServices(clazz).add(service);
        this.getAdded(clazz).add(service);
    }

    public void removeService(Class clazz, Object service) {
        this.getAllServices(clazz).remove(service);
        this.getRemoved(clazz).add(service);
    }

    public void removeAllServices() {
        for (Class clazz : this.services.keySet()) {
            List serviceList = this.services.get(clazz);
            for (Object service : serviceList) {
                this.removeService(clazz, service);
            }
        }
    }

    public List getAllServices(Class clazz) {
        ArrayList retval = this.services.get(clazz);
        if (retval == null) {
            retval = new ArrayList();
            this.services.put(clazz, retval);
        }
        return retval;
    }

    public List getAdded(Class clazz) {
        ArrayList retval = this.added.get(clazz);
        if (retval == null) {
            retval = new ArrayList();
            this.added.put(clazz, retval);
        }
        return retval;
    }

    public List getRemoved(Class clazz) {
        ArrayList retval = this.removed.get(clazz);
        if (retval == null) {
            retval = new ArrayList();
            this.removed.put(clazz, retval);
        }
        return retval;
    }

    public void clearHistory() {
        this.removed.clear();
        this.added.clear();
    }
}

