/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.importexport;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.importexport.AbstractContactTest;
import com.openexchange.groupware.importexport.ImportResult;
import com.openexchange.groupware.importexport.importers.TestCSVContactImporter;
import com.openexchange.importexport.formats.Format;
import com.openexchange.session.Session;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import org.junit.Assert;
import org.junit.Before;

public class OutlookCSVContactImportTest
extends AbstractContactTest {
    public String IMPORT_HEADERS = "Last Name,E-mail Address,Birthday\n";
    public String IMPORT_ONE = this.IMPORT_HEADERS + this.NAME1 + ", " + this.EMAIL1 + ", " + DATE1;
    public static String DATE1 = "4/1/1981";

    public OutlookCSVContactImportTest() throws Exception {
        this.defaultFormat = Format.OUTLOOK_CSV;
        imp = new TestCSVContactImporter();
    }

    @Before
    public void TearUp() throws OXException {
        folderId = OutlookCSVContactImportTest.createTestFolder(3, sessObj, ctx, "csvContactTestFolder");
    }

    public static Test suite() {
        return new JUnit4TestAdapter(OutlookCSVContactImportTest.class);
    }

    protected void checkFirstResult(int objectID) throws OXException, OXException, ParseException {
        Contact co = this.getEntry(objectID);
        Assert.assertEquals((String)"Checking name", (Object)this.NAME1, (Object)co.getSurName());
        Assert.assertEquals((String)"Checking e-Mail", (Object)this.EMAIL1, (Object)co.getEmail1());
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        Date compDate = null;
        compDate = sdf.parse(DATE1);
        this.assertDateEquals(compDate, co.getBirthday());
    }

    @org.junit.Test
    public void importOneContact() throws NumberFormatException, Exception {
        List<ImportResult> results = this.importStuff(this.IMPORT_ONE);
        Assert.assertEquals((String)"One result?", (Object)1, (Object)results.size());
        ImportResult res = results.get(0);
        if (res.hasError()) {
            res.getException().printStackTrace();
        }
        Assert.assertTrue((boolean)res.isCorrect());
        Assert.assertEquals((String)"One contact in folder?", (long)1L, (long)this.getNumberOfContacts(folderId));
        this.checkFirstResult(Integer.parseInt(res.getObjectId()));
    }

    @org.junit.Test
    public void bug7105() throws NumberFormatException, Exception {
        List<ImportResult> results = this.importStuff(this.IMPORT_ONE + "\n" + this.NAME2);
        Assert.assertEquals((String)"Two results?", (Object)2, (Object)results.size());
        int i = 0;
        for (ImportResult res : results) {
            Assert.assertEquals((String)("Entry " + i++ + " is correct?"), null, (Object)((Object)res.getException()));
        }
    }

    @org.junit.Test
    public void bug7552() throws NumberFormatException, Exception {
        List<ImportResult> results = this.importStuff(this.IMPORT_HEADERS + this.NAME1 + ", " + this.EMAIL1 + ", 1.4.1981");
        Assert.assertEquals((String)"One result?", (Object)1, (Object)results.size());
        ImportResult res = results.get(0);
        if (res.hasError()) {
            res.getException().printStackTrace();
        }
        Date birthday = this.getEntry(Integer.valueOf(res.getObjectId())).getBirthday();
        this.assertDateEquals(new SimpleDateFormat("dd.MM.yyyy").parse("1.4.1981"), birthday);
        this.contactStorage.delete((Session)sessObj, res.getFolder(), res.getObjectId(), res.getDate());
    }

    @org.junit.Test
    public void bug7710() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        String file = "Nachname, Vertraulichkeit\nTobias Prinz,PRIVAT";
        List<ImportResult> results = this.importStuff(file);
        Assert.assertEquals((String)"Only one result", (Object)1, (Object)results.size());
        ImportResult res = results.get(0);
        Contact conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertTrue((String)"Is private?", (boolean)conObj.getPrivateFlag());
        file = "Nachname, Vertraulichkeit\nTobias Prinz,\u00d6FFENTLICH";
        results = this.importStuff(file);
        Assert.assertEquals((String)"Only one result", (Object)1, (Object)results.size());
        res = results.get(0);
        conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertTrue((String)"Is private?", (!conObj.getPrivateFlag() ? 1 : 0) != 0);
    }

    @org.junit.Test
    public void bug9367_should_translate_several_more_fields_in_German() throws UnsupportedEncodingException, NumberFormatException, OXException {
        String file = "\"Anrede\",\"Vorname\",\"Weitere Vornamen\",\"Nachname\",\"Suffix\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe gesch\u00e4ftlich\",\"Stra\u00dfe gesch\u00e4ftlich 2\",\"Stra\u00dfe gesch\u00e4ftlich 3\",\"Ort gesch\u00e4ftlich\",\"Region gesch\u00e4ftlich\",\"Postleitzahl gesch\u00e4ftlich\",\"Land/Region gesch\u00e4ftlich\",\"Stra\u00dfe privat\",\"Stra\u00dfe privat 2\",\"Stra\u00dfe privat 3\",\"Ort privat\",\"Bundesland/Kanton privat\",\"Postleitzahl privat\",\"Land/Region privat\",\"Weitere Stra\u00dfe\",\"Weitere Stra\u00dfe 2\",\"Weitere Stra\u00dfe 3\",\"Weiterer Ort\",\"Weiteres/r Bundesland/Kanton\",\"Weitere Postleitzahl\",\"Weiteres/e Land/Region\",\"Telefon Assistent\",\"Fax gesch\u00e4ftlich\",\"Telefon gesch\u00e4ftlich\",\"Telefon gesch\u00e4ftlich 2\",\"R\u00fcckmeldung\",\"Autotelefon\",\"Telefon Firma\",\"Fax privat\",\"Telefon privat\",\"Telefon privat 2\",\"ISDN\",\"Mobiltelefon\",\"Weiteres Fax\",\"Weiteres Telefon\",\"Pager\",\"Haupttelefon\",\"Mobiltelefon 2\",\"Telefon f\u00fcr H\u00f6rbehinderte\",\"Telex\",\"Abrechnungsinformation\",\"Benutzer 1\",\"Benutzer 2\",\"Benutzer 3\",\"Benutzer 4\",\"Beruf\",\"B\u00fcro\",\"E-Mail-Adresse\",\"E-Mail-Typ\",\"E-Mail: Angezeigter Name\",\"E-Mail 2: Adresse\",\"E-Mail 2: Typ\",\"E-Mail 2: Angezeigter Name\",\"E-Mail 3: Adresse\",\"E-Mail 3: Typ\",\"E-Mail 3: Angezeigter Name\",\"Empfohlen von\",\"Geburtstag\",\"Geschlecht\",\"Hobby\",\"Initialen\",\"Internet-Frei/Gebucht\",\"Jahrestag\",\"Kategorien\",\"Kinder\",\"Konto\",\"Name Assistent\",\"Name des/der Vorgesetzten\",\"Notizen\",\"Organisationsnr.\",\"Ort\",\"Partner\",\"Postfach gesch\u00e4ftlich\",\"Postfach privat\",\"Priorit\u00e4t\",\"Privat\",\"Regierungsnr.\",\"Reisekilometer\",\"Sprache\",\"Stichw\u00f6rter\",\"Vertraulichkeit\",\"Verzeichnisserver\",\"Webseite\",\"Weiteres Postfach\"\n\"Anrede\",\"Vorname\",\"Zweiter Vorname\",\"Nachname\",\"Namenszusatz\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe\",,,\"Stadt\",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe\",,,\" Stadt \",\"Bundesland privat\",\"PLZ\",\"Land\",\"Stra\u00dfe (weitere)\",,,\"Stadt (weitere)\",\"Bundesland (weiteres)\",\"PLZ\",\"Land (weiteres)\",,\"Fax (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich 2)\",,\"Autotelefon\",\"Telefon (Zentrale)\",\"Fax (privat)\",\"Telefon (privat)\",\"Telefon (privat 2)\",,\"Mobiltelefon\",\"Fax (weiteres)\",\"Telefon (weiteres)\",\"Pager\",,,\"Texttelefon\",\"Telex\",,,,,,\"Beruf\",\"Raumnummer\",\"email@geschaeftlich.tld\",\"SMTP\",\"Angezeigter Name (email@geschaeftlich.tld)\",\"email@privat.tld\",\"SMTP\",\"Angezeigter Name (email@privat.tld)\",\"email@weitere.tld\",\"SMTP\",\"Angezeigter Name (email@weitere.tld)\",,\"10.9.2007\",\"Keine Angabe\",,,,\"9.9.2007\",\"Tag1\",,,\"Assistent\",\"Manager\",\"Anmerkungen\",,,\"Ehepartner\",,,\"Niedrig\",\"Ein\",,,,,\"Privat\",,\"URL\"";
        List<ImportResult> results = this.importStuff("\"Anrede\",\"Vorname\",\"Weitere Vornamen\",\"Nachname\",\"Suffix\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe gesch\u00e4ftlich\",\"Stra\u00dfe gesch\u00e4ftlich 2\",\"Stra\u00dfe gesch\u00e4ftlich 3\",\"Ort gesch\u00e4ftlich\",\"Region gesch\u00e4ftlich\",\"Postleitzahl gesch\u00e4ftlich\",\"Land/Region gesch\u00e4ftlich\",\"Stra\u00dfe privat\",\"Stra\u00dfe privat 2\",\"Stra\u00dfe privat 3\",\"Ort privat\",\"Bundesland/Kanton privat\",\"Postleitzahl privat\",\"Land/Region privat\",\"Weitere Stra\u00dfe\",\"Weitere Stra\u00dfe 2\",\"Weitere Stra\u00dfe 3\",\"Weiterer Ort\",\"Weiteres/r Bundesland/Kanton\",\"Weitere Postleitzahl\",\"Weiteres/e Land/Region\",\"Telefon Assistent\",\"Fax gesch\u00e4ftlich\",\"Telefon gesch\u00e4ftlich\",\"Telefon gesch\u00e4ftlich 2\",\"R\u00fcckmeldung\",\"Autotelefon\",\"Telefon Firma\",\"Fax privat\",\"Telefon privat\",\"Telefon privat 2\",\"ISDN\",\"Mobiltelefon\",\"Weiteres Fax\",\"Weiteres Telefon\",\"Pager\",\"Haupttelefon\",\"Mobiltelefon 2\",\"Telefon f\u00fcr H\u00f6rbehinderte\",\"Telex\",\"Abrechnungsinformation\",\"Benutzer 1\",\"Benutzer 2\",\"Benutzer 3\",\"Benutzer 4\",\"Beruf\",\"B\u00fcro\",\"E-Mail-Adresse\",\"E-Mail-Typ\",\"E-Mail: Angezeigter Name\",\"E-Mail 2: Adresse\",\"E-Mail 2: Typ\",\"E-Mail 2: Angezeigter Name\",\"E-Mail 3: Adresse\",\"E-Mail 3: Typ\",\"E-Mail 3: Angezeigter Name\",\"Empfohlen von\",\"Geburtstag\",\"Geschlecht\",\"Hobby\",\"Initialen\",\"Internet-Frei/Gebucht\",\"Jahrestag\",\"Kategorien\",\"Kinder\",\"Konto\",\"Name Assistent\",\"Name des/der Vorgesetzten\",\"Notizen\",\"Organisationsnr.\",\"Ort\",\"Partner\",\"Postfach gesch\u00e4ftlich\",\"Postfach privat\",\"Priorit\u00e4t\",\"Privat\",\"Regierungsnr.\",\"Reisekilometer\",\"Sprache\",\"Stichw\u00f6rter\",\"Vertraulichkeit\",\"Verzeichnisserver\",\"Webseite\",\"Weiteres Postfach\"\n\"Anrede\",\"Vorname\",\"Zweiter Vorname\",\"Nachname\",\"Namenszusatz\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe\",,,\"Stadt\",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe\",,,\" Stadt \",\"Bundesland privat\",\"PLZ\",\"Land\",\"Stra\u00dfe (weitere)\",,,\"Stadt (weitere)\",\"Bundesland (weiteres)\",\"PLZ\",\"Land (weiteres)\",,\"Fax (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich 2)\",,\"Autotelefon\",\"Telefon (Zentrale)\",\"Fax (privat)\",\"Telefon (privat)\",\"Telefon (privat 2)\",,\"Mobiltelefon\",\"Fax (weiteres)\",\"Telefon (weiteres)\",\"Pager\",,,\"Texttelefon\",\"Telex\",,,,,,\"Beruf\",\"Raumnummer\",\"email@geschaeftlich.tld\",\"SMTP\",\"Angezeigter Name (email@geschaeftlich.tld)\",\"email@privat.tld\",\"SMTP\",\"Angezeigter Name (email@privat.tld)\",\"email@weitere.tld\",\"SMTP\",\"Angezeigter Name (email@weitere.tld)\",,\"10.9.2007\",\"Keine Angabe\",,,,\"9.9.2007\",\"Tag1\",,,\"Assistent\",\"Manager\",\"Anmerkungen\",,,\"Ehepartner\",,,\"Niedrig\",\"Ein\",,,,,\"Privat\",,\"URL\"", "cp1252");
        Assert.assertEquals((String)"Only one result", (long)1L, (long)results.size());
        ImportResult res = results.get(0);
        res.getException().printStackTrace();
        String objectId = res.getObjectId();
        Assert.assertNotNull((String)"Identifier of imported object is missing", (Object)objectId);
        Contact conObj = this.getEntry(Integer.parseInt(objectId));
        Assert.assertEquals((Object)"Position", (Object)conObj.getPosition());
        Assert.assertEquals((Object)"Raumnummer", (Object)conObj.getRoomNumber());
        Assert.assertEquals((Object)"Bundesland privat", (Object)conObj.getStateHome());
        Assert.assertEquals((Object)"Land", (Object)conObj.getCountryHome());
        Assert.assertEquals((Object)"Bundesland (weiteres)", (Object)conObj.getStateOther());
        Assert.assertEquals((Object)"Land (weiteres)", (Object)conObj.getCountryOther());
        Assert.assertEquals((Object)"email@weitere.tld", (Object)conObj.getEmail3());
        Assert.assertEquals((Object)"Bundesland", (Object)conObj.getStateBusiness());
        Assert.assertEquals((Object)"email@geschaeftlich.tld", (Object)conObj.getEmail1());
    }

    public void bug9367_should_translate_several_more_fields_in_English() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        String file = "\"Title\",\"First Name\",\"Middle Name\",\"Last Name\",\"Suffix\",\"Company\",\"Department\",\"Job Title\",\"Business Street\",\"Business Street 2\",\"Business Street 3\",\"Business City\",\"Business State\",\"Business Postal Code\",\"Business Country/Region\",\"Home Street\",\"Home Street 2\",\"Home Street 3\",\"Home City\",\"Home State\",\"Home Postal Code\",\"Home Country/Region\",\"Other Street\",\"Other Street 2\",\"Other Street 3\",\"Other City\",\"Other State\",\"Other Postal Code\",\"Other Country/Region\",\"Assistant's Phone\",\"Business Fax\",\"Business Phone\",\"Business Phone 2\",\"Callback\",\"Car Phone\",\"Company Main Phone\",\"Home Fax\",\"Home Phone\",\"Home Phone 2\",\"ISDN\",\"Mobile Phone\",\"Other Fax\",\"Other Phone\",\"Pager\",\"Primary Phone\",\"Radio Phone\",\"TTY/TDD Phone\",\"Telex\",\"Account\",\"Anniversary\",\"Assistant's Name\",\"Billing Information\",\"Birthday\",\"Business Address PO Box\",\"Categories\",\"Children\",\"Directory Server\",\"E-mail Address\",\"E-mail Type\",\"E-mail Display Name\",\"E-mail 2 Address\",\"E-mail 2 Type\",\"E-mail 2 Display Name\",\"E-mail 3 Address\",\"E-mail 3 Type\",\"E-mail 3 Display Name\",\"Gender\",\"Government ID Number\",\"Hobby\",\"Home Address PO Box\",\"Initials\",\"Internet Free Busy\",\"Keywords\",\"Language\",\"Location\",\"Manager's Name\",\"Mileage\",\"Notes\",\"Office Location\",\"Organizational ID Number\",\"Other Address PO Box\",\"Priority\",\"Private\",\"Profession\",\"Referred By\",\"Sensitivity\",\"Spouse\",\"User 1\",\"User 2\",\"User 3\",\"User 4\",\"Web Page\"\n\"Anrede\",\"Vorname\",\"Zweiter Vorname\",\"Nachname\",\"Namenszusatz\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe\",,,\"Stadt\",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe\",,,\" Stadt \",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe (weitere)\",,,\"Stadt (weitere)\",\"Bundesland (weiteres)\",\"PLZ\",\"Land (weiteres)\",,\"Fax (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich 2)\",,\"Autotelefon\",\"Telefon (Zentrale)\",\"Fax (privat)\",\"Telefon (privat)\",\"Telefon (privat 2)\",,\"Mobiltelefon\",\"Fax (weiteres)\",\"Telefon (weiteres)\",\"Pager\",,,\"Texttelefon\",\"Telex\",,,,,,\"Beruf\",\"Raumnummer\",\"email@geschaeftlich.tld\",\"SMTP\",\"Angezeigter Name (email@geschaeftlich.tld)\",\"email@privat.tld\",\"SMTP\",\"Angezeigter Name (email@privat.tld)\",\"email@weitere.tld\",\"SMTP\",\"Angezeigter Name (email@weitere.tld)\",,\"10.9.2007\",\"Keine Angabe\",,,,\"9.9.2007\",\"Tag1\",,,\"Assistent\",\"Manager\",\"Anmerkungen\",,,\"Ehepartner\",,,\"Niedrig\",\"Ein\",,,,,\"Privat\",,\"URL\"";
        List<ImportResult> results = this.importStuff("\"Title\",\"First Name\",\"Middle Name\",\"Last Name\",\"Suffix\",\"Company\",\"Department\",\"Job Title\",\"Business Street\",\"Business Street 2\",\"Business Street 3\",\"Business City\",\"Business State\",\"Business Postal Code\",\"Business Country/Region\",\"Home Street\",\"Home Street 2\",\"Home Street 3\",\"Home City\",\"Home State\",\"Home Postal Code\",\"Home Country/Region\",\"Other Street\",\"Other Street 2\",\"Other Street 3\",\"Other City\",\"Other State\",\"Other Postal Code\",\"Other Country/Region\",\"Assistant's Phone\",\"Business Fax\",\"Business Phone\",\"Business Phone 2\",\"Callback\",\"Car Phone\",\"Company Main Phone\",\"Home Fax\",\"Home Phone\",\"Home Phone 2\",\"ISDN\",\"Mobile Phone\",\"Other Fax\",\"Other Phone\",\"Pager\",\"Primary Phone\",\"Radio Phone\",\"TTY/TDD Phone\",\"Telex\",\"Account\",\"Anniversary\",\"Assistant's Name\",\"Billing Information\",\"Birthday\",\"Business Address PO Box\",\"Categories\",\"Children\",\"Directory Server\",\"E-mail Address\",\"E-mail Type\",\"E-mail Display Name\",\"E-mail 2 Address\",\"E-mail 2 Type\",\"E-mail 2 Display Name\",\"E-mail 3 Address\",\"E-mail 3 Type\",\"E-mail 3 Display Name\",\"Gender\",\"Government ID Number\",\"Hobby\",\"Home Address PO Box\",\"Initials\",\"Internet Free Busy\",\"Keywords\",\"Language\",\"Location\",\"Manager's Name\",\"Mileage\",\"Notes\",\"Office Location\",\"Organizational ID Number\",\"Other Address PO Box\",\"Priority\",\"Private\",\"Profession\",\"Referred By\",\"Sensitivity\",\"Spouse\",\"User 1\",\"User 2\",\"User 3\",\"User 4\",\"Web Page\"\n\"Anrede\",\"Vorname\",\"Zweiter Vorname\",\"Nachname\",\"Namenszusatz\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe\",,,\"Stadt\",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe\",,,\" Stadt \",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe (weitere)\",,,\"Stadt (weitere)\",\"Bundesland (weiteres)\",\"PLZ\",\"Land (weiteres)\",,\"Fax (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich 2)\",,\"Autotelefon\",\"Telefon (Zentrale)\",\"Fax (privat)\",\"Telefon (privat)\",\"Telefon (privat 2)\",,\"Mobiltelefon\",\"Fax (weiteres)\",\"Telefon (weiteres)\",\"Pager\",,,\"Texttelefon\",\"Telex\",,,,,,\"Beruf\",\"Raumnummer\",\"email@geschaeftlich.tld\",\"SMTP\",\"Angezeigter Name (email@geschaeftlich.tld)\",\"email@privat.tld\",\"SMTP\",\"Angezeigter Name (email@privat.tld)\",\"email@weitere.tld\",\"SMTP\",\"Angezeigter Name (email@weitere.tld)\",,\"10.9.2007\",\"Keine Angabe\",,,,\"9.9.2007\",\"Tag1\",,,\"Assistent\",\"Manager\",\"Anmerkungen\",,,\"Ehepartner\",,,\"Niedrig\",\"Ein\",,,,,\"Privat\",,\"URL\"", "cp1252");
        Assert.assertEquals((String)"Only one result", (Object)1, (Object)results.size());
        ImportResult res = results.get(0);
        Contact conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertEquals((Object)"email@geschaeftlich.tld", (Object)conObj.getEmail1());
        Assert.assertEquals((Object)"Position", (Object)conObj.getPosition());
        Assert.assertEquals((Object)"Raumnummer", (Object)conObj.getRoomNumber());
        Assert.assertEquals((Object)"Bundesland", (Object)conObj.getStateHome());
        Assert.assertEquals((Object)"Land", (Object)conObj.getCountryHome());
        Assert.assertEquals((Object)"Bundesland (weiteres)", (Object)conObj.getStateOther());
        Assert.assertEquals((Object)"Land (weiteres)", (Object)conObj.getCountryOther());
        Assert.assertEquals((Object)"email@weitere.tld", (Object)conObj.getEmail3());
        Assert.assertEquals((Object)"Land", (Object)conObj.getStateBusiness());
    }

    public void bug9367_should_translate_several_more_fields_in_French() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        String file = "\"Titre\",\"Pr\u00c8nom\",\"Deuxi\u00cbme pr\u00c8nom\",\"Nom\",\"Suffixe\",\"Soci\u00c8t\u00c8\",\"Service\",\"Titre\",\"Rue (bureau)\",\"Rue (bureau) 2\",\"Rue (bureau) 3\",\"Ville (bureau)\",\"D\u00c8p/R\u00c8gion (bureau)\",\"Code postal (bureau)\",\"Pays/R\u00c8gion (bureau)\",\"Rue (domicile)\",\"Rue (domicile) 2\",\"Rue (domicile) 3\",\"Ville (domicile)\",\"D\u00c8p/R\u00c8gion (domicile)\",\"Code postal (domicile)\",\"Pays/R\u00c8gion (domicile)\",\"Rue (autre)\",\"Rue (autre) 2\",\"Rue (autre) 3\",\"Ville (autre)\",\"D\u00c8p/R\u00c8gion (autre)\",\"Code postal (autre)\",\"Pays/R\u00c8gion (autre)\",\"T\u00c8l\u00c8phone de l'assistant(e)\",\"T\u00c8l\u00c8copie (bureau)\",\"T\u00c8l\u00c8phone (bureau)\",\"T\u00c8l\u00c8phone 2 (bureau)\",\"Rappel\",\"T\u00c8l\u00c8phone (voiture)\",\"T\u00c8l\u00c8phone soci\u00c8t\u00c8\",\"T\u00c8l\u00c8copie (domicile)\",\"T\u00c8l\u00c8phone (domicile)\",\"T\u00c8l\u00c8phone 2 (domicile)\",\"RNIS\",\"T\u00c8l. mobile\",\"T\u00c8l\u00c8copie (autre)\",\"T\u00c8l\u00c8phone (autre)\",\"R\u00c8cepteur de radiomessagerie\",\"T\u00c8l\u00c8phone principal\",\"Radio t\u00c8l\u00c8phone\",\"T\u00c8l\u00c8phone TDD/TTY\",\"T\u00c8lex\",\"Adresse de messagerie\",\"Type de messagerie\",\"Nom complet de l'adresse de messagerie\",\"Adresse de messagerie 2\",\"Type de messagerie 2\",\"Nom complet de l'adresse de messagerie 2\",\"Adresse de messagerie 3\",\"Type de messagerie 3\",\"Nom complet de l'adresse de messagerie 3\",\"Anniversaire\",\"Anniversaire de mariage ou f\u00cdte\",\"Autre bo\u00d3te postale\",\"B.P. professionnelle\",\"Bo\u00d3te postale du domicile\",\"Bureau\",\"Cat\u00c8gories\",\"Code gouvernement\",\"Compte\",\"Conjoint(e)\",\"Crit\u00cbre de diffusion\",\"Disponibilit\u00c8 Internet\",\"Emplacement\",\"Enfants\",\"Informations facturation\",\"Initiales\",\"Kilom\u00c8trage\",\"Langue\",\"Mots cl\u00c8s\",\"Nom de l'assistant(e)\",\"Notes\",\"Num\u00c8ro d'identification de l'organisation\",\"Page Web\",\"Passe-temps\",\"Priorit\u00c8\",\"Priv\u00c8\",\"Profession\",\"Recommand\u00c8 par\",\"Responsable\",\"Serveur d'annuaire\",\"Sexe\",\"Utilisateur 1\",\"Utilisateur 2\",\"Utilisateur 3\",\"Utilisateur 4\"\n\"Anrede\",\"Vorname\",\"Zweiter Vorname\",\"Nachname\",\"Namenszusatz\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe\",,,\"Stadt\",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe\",,,\" Stadt \",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe (weitere)\",,,\"Stadt (weitere)\",\"Bundesland (weiteres)\",\"PLZ\",\"Land (weiteres)\",,\"Fax (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich 2)\",,\"Autotelefon\",\"Telefon (Zentrale)\",\"Fax (privat)\",\"Telefon (privat)\",\"Telefon (privat 2)\",,\"Mobiltelefon\",\"Fax (weiteres)\",\"Telefon (weiteres)\",\"Pager\",,,\"Texttelefon\",\"Telex\",,,,,,\"Beruf\",\"Raumnummer\",\"email@geschaeftlich.tld\",\"SMTP\",\"Angezeigter Name (email@geschaeftlich.tld)\",\"email@privat.tld\",\"SMTP\",\"Angezeigter Name (email@privat.tld)\",\"email@weitere.tld\",\"SMTP\",\"Angezeigter Name (email@weitere.tld)\",,\"10.9.2007\",\"Keine Angabe\",,,,\"9.9.2007\",\"Tag1\",,,\"Assistent\",\"Manager\",\"Anmerkungen\",,,\"Ehepartner\",,,\"Niedrig\",\"Ein\",,,,,\"Privat\",,\"URL\"";
        List<ImportResult> results = this.importStuff("\"Titre\",\"Pr\u00c8nom\",\"Deuxi\u00cbme pr\u00c8nom\",\"Nom\",\"Suffixe\",\"Soci\u00c8t\u00c8\",\"Service\",\"Titre\",\"Rue (bureau)\",\"Rue (bureau) 2\",\"Rue (bureau) 3\",\"Ville (bureau)\",\"D\u00c8p/R\u00c8gion (bureau)\",\"Code postal (bureau)\",\"Pays/R\u00c8gion (bureau)\",\"Rue (domicile)\",\"Rue (domicile) 2\",\"Rue (domicile) 3\",\"Ville (domicile)\",\"D\u00c8p/R\u00c8gion (domicile)\",\"Code postal (domicile)\",\"Pays/R\u00c8gion (domicile)\",\"Rue (autre)\",\"Rue (autre) 2\",\"Rue (autre) 3\",\"Ville (autre)\",\"D\u00c8p/R\u00c8gion (autre)\",\"Code postal (autre)\",\"Pays/R\u00c8gion (autre)\",\"T\u00c8l\u00c8phone de l'assistant(e)\",\"T\u00c8l\u00c8copie (bureau)\",\"T\u00c8l\u00c8phone (bureau)\",\"T\u00c8l\u00c8phone 2 (bureau)\",\"Rappel\",\"T\u00c8l\u00c8phone (voiture)\",\"T\u00c8l\u00c8phone soci\u00c8t\u00c8\",\"T\u00c8l\u00c8copie (domicile)\",\"T\u00c8l\u00c8phone (domicile)\",\"T\u00c8l\u00c8phone 2 (domicile)\",\"RNIS\",\"T\u00c8l. mobile\",\"T\u00c8l\u00c8copie (autre)\",\"T\u00c8l\u00c8phone (autre)\",\"R\u00c8cepteur de radiomessagerie\",\"T\u00c8l\u00c8phone principal\",\"Radio t\u00c8l\u00c8phone\",\"T\u00c8l\u00c8phone TDD/TTY\",\"T\u00c8lex\",\"Adresse de messagerie\",\"Type de messagerie\",\"Nom complet de l'adresse de messagerie\",\"Adresse de messagerie 2\",\"Type de messagerie 2\",\"Nom complet de l'adresse de messagerie 2\",\"Adresse de messagerie 3\",\"Type de messagerie 3\",\"Nom complet de l'adresse de messagerie 3\",\"Anniversaire\",\"Anniversaire de mariage ou f\u00cdte\",\"Autre bo\u00d3te postale\",\"B.P. professionnelle\",\"Bo\u00d3te postale du domicile\",\"Bureau\",\"Cat\u00c8gories\",\"Code gouvernement\",\"Compte\",\"Conjoint(e)\",\"Crit\u00cbre de diffusion\",\"Disponibilit\u00c8 Internet\",\"Emplacement\",\"Enfants\",\"Informations facturation\",\"Initiales\",\"Kilom\u00c8trage\",\"Langue\",\"Mots cl\u00c8s\",\"Nom de l'assistant(e)\",\"Notes\",\"Num\u00c8ro d'identification de l'organisation\",\"Page Web\",\"Passe-temps\",\"Priorit\u00c8\",\"Priv\u00c8\",\"Profession\",\"Recommand\u00c8 par\",\"Responsable\",\"Serveur d'annuaire\",\"Sexe\",\"Utilisateur 1\",\"Utilisateur 2\",\"Utilisateur 3\",\"Utilisateur 4\"\n\"Anrede\",\"Vorname\",\"Zweiter Vorname\",\"Nachname\",\"Namenszusatz\",\"Firma\",\"Abteilung\",\"Position\",\"Stra\u00dfe\",,,\"Stadt\",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe\",,,\" Stadt \",\"Bundesland\",\"PLZ\",\"Land\",\"Stra\u00dfe (weitere)\",,,\"Stadt (weitere)\",\"Bundesland (weiteres)\",\"PLZ\",\"Land (weiteres)\",,\"Fax (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich)\",\"Telefon (gesch\u00e4ftlich 2)\",,\"Autotelefon\",\"Telefon (Zentrale)\",\"Fax (privat)\",\"Telefon (privat)\",\"Telefon (privat 2)\",,\"Mobiltelefon\",\"Fax (weiteres)\",\"Telefon (weiteres)\",\"Pager\",,,\"Texttelefon\",\"Telex\",,,,,,\"Beruf\",\"Raumnummer\",\"email@geschaeftlich.tld\",\"SMTP\",\"Angezeigter Name (email@geschaeftlich.tld)\",\"email@privat.tld\",\"SMTP\",\"Angezeigter Name (email@privat.tld)\",\"email@weitere.tld\",\"SMTP\",\"Angezeigter Name (email@weitere.tld)\",,\"10.9.2007\",\"Keine Angabe\",,,,\"9.9.2007\",\"Tag1\",,,\"Assistent\",\"Manager\",\"Anmerkungen\",,,\"Ehepartner\",,,\"Niedrig\",\"Ein\",,,,,\"Privat\",,\"URL\"", "cp1252");
        Assert.assertEquals((String)"Only one result", (Object)1, (Object)results.size());
        ImportResult res = results.get(0);
        Contact conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertEquals((Object)"email@geschaeftlich.tld", (Object)conObj.getEmail1());
        Assert.assertEquals((Object)"Position", (Object)conObj.getPosition());
        Assert.assertEquals((Object)"Raumnummer", (Object)conObj.getRoomNumber());
        Assert.assertEquals((Object)"Bundesland", (Object)conObj.getStateHome());
        Assert.assertEquals((Object)"Land", (Object)conObj.getCountryHome());
        Assert.assertEquals((Object)"Bundesland (weiteres)", (Object)conObj.getStateOther());
        Assert.assertEquals((Object)"Land (weiteres)", (Object)conObj.getCountryOther());
        Assert.assertEquals((Object)"email@weitere.tld", (Object)conObj.getEmail3());
        Assert.assertEquals((Object)"Land", (Object)conObj.getStateBusiness());
    }

    @org.junit.Test
    public void bug15247() throws Exception {
        String file = "First Name, Last Name, Account\nTobias, Prinz, fails!";
        List<ImportResult> results = this.importStuff("First Name, Last Name, Account\nTobias, Prinz, fails!");
        Assert.assertTrue((String)"Only one result", (1 == results.size() ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        Contact conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertFalse((String)"Should not set e-mail address", (boolean)conObj.containsEmail1());
        Assert.assertEquals((String)"Should only criticize that 'Account' cannot be translated", (Object)"I_E-0803", (Object)res.getException().getErrorCode());
    }

    @org.junit.Test
    public void dontFuzzAboutTruncations() throws Exception {
        String file = "Last Name\nHadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D...as War Knapp Und Wird Hier Abgeschnitten";
        List<ImportResult> results = this.importStuff("Last Name\nHadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D...as War Knapp Und Wird Hier Abgeschnitten");
        Assert.assertEquals((String)"Should give one result", (long)1L, (long)results.size());
        ImportResult res = results.get(0);
        Assert.assertFalse((String)"Should not contain error", (boolean)res.hasError());
        Contact conObj = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertEquals((Object)"Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi Dawuhd al Gossarah Hadschi Halef Omar Ben Hadschi Abul Abbas Ibn Hadschi D", (Object)conObj.getSurName());
    }

    public void shouldCombineSplitDatesInDutchCSV() throws UnsupportedEncodingException, NumberFormatException, OXException, OXException {
        String csv = "Voornaam, Achternaam, Geboortejaar, Geboortemaand, Geboortedag\nTobias,   Prinz,      1980,         12,            31";
        List<ImportResult> results = this.importStuff("Voornaam, Achternaam, Geboortejaar, Geboortemaand, Geboortedag\nTobias,   Prinz,      1980,         12,            31");
        Assert.assertTrue((String)"Only one result", (1 == results.size() ? 1 : 0) != 0);
        ImportResult res = results.get(0);
        Contact contact = this.getEntry(Integer.parseInt(res.getObjectId()));
        Assert.assertTrue((String)"Birthday should have been set", (boolean)contact.containsBirthday());
        String actual = new SimpleDateFormat("yyyy-MM-dd").format(contact.getBirthday());
        Assert.assertEquals((String)"Birthday should match (day-wise)", (Object)"1980-12-31", (Object)actual);
    }

    @org.junit.Test
    public void dontImportIfDisplayNameCanBeFormedAtAll() throws Exception {
        String file = "Business Country\nNo one likes an empty entry with a country field only";
        try {
            this.importStuff("Business Country\nNo one likes an empty entry with a country field only");
            Assert.fail((String)"Should throw exception");
        }
        catch (OXException e) {
            Assert.assertEquals((String)"Should throw exception for missing fields to build a display name", (long)807L, (long)e.getCode());
        }
    }

    @org.junit.Test
    public void dontImportIfNoDisplayNameCanBeFormedForAGivenContact() throws Exception {
        String file = "Sur name,Bullshit\n,Something unimportant";
        List<ImportResult> results = this.importStuff("Sur name,Bullshit\n,Something unimportant");
        Assert.assertEquals((String)"Should give one result", (long)1L, (long)results.size());
        ImportResult res = results.get(0);
        Assert.assertTrue((String)"Needs to contain one error", (boolean)res.hasError());
        OXException exception = res.getException();
        Assert.assertEquals((String)"Should have a problem because there is no material for a display name", (long)808L, (long)exception.getCode());
    }

    public void assertDateEquals(Date date1, Date date2) {
        GregorianCalendar c1 = new GregorianCalendar();
        GregorianCalendar c2 = new GregorianCalendar();
        c1.setTime(date1);
        c2.setTime(date2);
        Assert.assertEquals((String)"Day", (Object)c1.get(5), (Object)c2.get(5));
        Assert.assertEquals((String)"Month", (Object)c1.get(2), (Object)c2.get(2));
        Assert.assertEquals((String)"Year", (Object)c1.get(1), (Object)c2.get(1));
    }
}

