/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.calendar.calendarsqltests;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.calendar.calendarsqltests.CalendarSqlTest;
import java.util.Date;

public class Bug15155Test
extends CalendarSqlTest {
    private CalendarDataObject appointment;
    private CalendarDataObject changeAppointment;
    private Date newStart;
    private Date newEnd;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.appointment = this.appointments.buildAppointmentWithUserParticipants(this.user);
        this.appointment.setStartDate(TimeTools.D("24.12.2009 08:00"));
        this.appointment.setEndDate(TimeTools.D("24.12.2009 09:00"));
        this.appointment.setRecurrenceType(1);
        this.appointment.setInterval(1);
        this.appointments.save(this.appointment);
        this.clean.add(this.appointment);
        this.changeAppointment = this.appointments.createIdentifyingCopy(this.appointment);
        this.newStart = TimeTools.D("22.12.2009 08:00");
        this.newEnd = TimeTools.D("22.12.2009 09:00");
        this.changeAppointment.setStartDate(this.newStart);
        this.changeAppointment.setEndDate(this.newEnd);
        this.changeAppointment.setRecurrenceType(1);
        this.changeAppointment.setInterval(1);
    }

    public void testBugStartChange() throws Exception {
        this.appointments.save(this.changeAppointment);
        CalendarDataObject loadAppointment = this.appointments.load(this.appointment.getObjectID(), this.appointment.getParentFolderID());
        Bug15155Test.assertEquals((String)"Wrong series start.", (long)this.newStart.getTime(), (long)loadAppointment.getStartDate().getTime());
        Bug15155Test.assertEquals((String)"Wrong end date.", (long)this.newEnd.getTime(), (long)loadAppointment.getEndDate().getTime());
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

