/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class NewTest
extends CardDAVTest {
    @Test
    public void testCreateSimpleOnClient() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "horst";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:horst;test;;;\r\nFN:test horst\r\nORG:test3;\r\nEMAIL;type=INTERNET;type=WORK;type=pref:test@example.com\r\nTEL;type=WORK;type=pref:24235423\r\nTEL;type=CELL:352-3534\r\nTEL;type=HOME:346346\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"test", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"horst", (Object)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"test", (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)"horst", (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)"test horst", (Object)card.getFN());
    }

    @Test
    public void testCreateSimpleOnServer() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "otto";
        Contact contact = new Contact();
        contact.setSurName("otto");
        contact.setGivenName("test");
        contact.setDisplayName("test otto");
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"test", (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)"otto", (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)"test otto", (Object)card.getFN());
        contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"test", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"otto", (Object)contact.getSurName());
    }

    @Test
    public void testAddContactInSubfolderServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + NewTest.randomUID();
        FolderObject folder = super.createFolder(folderName);
        super.rememberForCleanUp(folder);
        FolderObject createdFolder = super.getFolder(folderName);
        Assert.assertNotNull((String)"folder not found on server", (Object)createdFolder);
        Assert.assertEquals((String)"foldername wrong", (Object)folderName, (Object)createdFolder.getFolderName());
        String uid = NewTest.randomUID();
        String firstName = "test";
        String lastName = "herbert";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, createdFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = NewTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)card.getFN());
    }
}

