/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class MoveTest
extends CardDAVTest {
    @Test
    public void testMoveContactToSubfolderOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String subFolderName = "testfolder_" + MoveTest.randomUID();
        FolderObject subFolder = super.createFolder(subFolderName);
        super.rememberForCleanUp(subFolder);
        String uid = MoveTest.randomUID();
        String firstName = "test";
        String lastName = "jaqueline";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = MoveTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)contactCard.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)contactCard.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)contactCard.getFN());
        contact.setParentFolderID(subFolder.getObjectID());
        super.update(super.getDefaultFolder().getObjectID(), contact);
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        contactCard = MoveTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)contactCard.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)contactCard.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)contactCard.getFN());
    }

    @Test
    public void testMoveContactToDefaultFolderOnServer() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String subFolderName = "testfolder_" + MoveTest.randomUID();
        FolderObject subFolder = super.createFolder(subFolderName);
        super.rememberForCleanUp(subFolder);
        String uid = MoveTest.randomUID();
        String firstName = "test";
        String lastName = "jaqueline";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, subFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = MoveTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)contactCard.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)contactCard.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)contactCard.getFN());
        contact.setParentFolderID(super.getDefaultFolder().getObjectID());
        super.update(subFolder.getObjectID(), contact);
        contact.setParentFolderID(subFolder.getObjectID());
        eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        addressData = super.addressbookMultiget(eTags.keySet());
        contactCard = MoveTest.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)contactCard.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)contactCard.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)contactCard.getFN());
    }
}

