/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug36943Test
extends CardDAVTest {
    @Test
    public void testAddAstralSymbols() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug36943Test.randomUID();
        String firstName = "Pile of \ud83d\udca9 poo";
        String lastName = "test";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        String expectedFirstName = firstName.replaceAll("\ud83d\udca9", "");
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)expectedFirstName, (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)lastName, (Object)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug36943Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)expectedFirstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(expectedFirstName + " " + lastName), (Object)card.getFN());
    }
}

