/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.dav.reports.SyncCollectionResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug23078Test
extends CardDAVTest {
    @Test
    public void testReportItemsFromDeletedFolder() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        String folderName = "testfolder_" + Bug23078Test.randomUID();
        FolderObject subFolder = super.createFolder(folderName);
        super.rememberForCleanUp(subFolder);
        String uid = Bug23078Test.randomUID();
        String firstName = "doktor";
        String lastName = "horst";
        Contact contact = new Contact();
        contact.setSurName(lastName);
        contact.setGivenName(firstName);
        contact.setDisplayName(firstName + " " + lastName);
        contact.setUid(uid);
        super.rememberForCleanUp(super.create(contact, subFolder.getObjectID()));
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource contactCard = Bug23078Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)contactCard.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)contactCard.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)contactCard.getFN());
        super.deleteFolder(subFolder);
        SyncCollectionResponse syncCollectionResponse = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource deletions reported on sync collection", (0 < syncCollectionResponse.getHrefsStatusNotFound().size() ? 1 : 0) != 0);
        boolean found = false;
        for (String href : syncCollectionResponse.getHrefsStatusNotFound()) {
            if (null == href || !href.contains(uid)) continue;
            found = true;
            break;
        }
        Assert.assertTrue((String)"contact not reported as deleted", (boolean)found);
    }
}

