/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug23046Test
extends CardDAVTest {
    @Test
    public void testCreateWithURLWithoutAuthority() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug23046Test.randomUID();
        String firstName = "test";
        String lastName = "jupp";
        String url = "http://";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:" + lastName + ";" + firstName + ";;;" + "\r\n" + "FN:" + firstName + " " + lastName + "\r\n" + "URL:" + url + "\r\n" + "UID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.1//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"url wrong", (Object)url, (Object)contact.getURL());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug23046Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)firstName, (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)lastName, (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)(firstName + " " + lastName), (Object)card.getFN());
        Assert.assertNotNull((String)"URL wrong", card.getVCard().getUrls().get(0));
    }
}

