/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.dav.carddav.VCardResource;
import com.openexchange.groupware.container.Contact;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class Bug21177Test
extends CardDAVTest {
    @Test
    public void testAddSpecialCharacters() throws Exception {
        String syncToken = super.fetchSyncToken();
        String uid = Bug21177Test.randomUID();
        String firstName = "\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5";
        String lastName = "test";
        String vCard = "BEGIN:VCARD\r\nVERSION:3.0\r\nN:test;\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5;;;\r\nFN:\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5 test\r\nUID:" + uid + "\r\n" + "REV:" + CardDAVTest.formatAsUTC(new Date()) + "\r\n" + "PRODID:-//Apple Inc.//AddressBook 6.0//EN" + "\r\n" + "END:VCARD" + "\r\n";
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putVCard(uid, vCard));
        Contact contact = super.getContact(uid);
        super.rememberForCleanUp(contact);
        Assert.assertEquals((String)"uid wrong", (Object)uid, (Object)contact.getUid());
        Assert.assertEquals((String)"firstname wrong", (Object)"\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5", (Object)contact.getGivenName());
        Assert.assertEquals((String)"lastname wrong", (Object)"test", (Object)contact.getSurName());
        Map<String, String> eTags = super.syncCollection(syncToken);
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<VCardResource> addressData = super.addressbookMultiget(eTags.keySet());
        VCardResource card = Bug21177Test.assertContains(uid, addressData);
        Assert.assertEquals((String)"N wrong", (Object)"\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5", (Object)card.getGivenName());
        Assert.assertEquals((String)"N wrong", (Object)"test", (Object)card.getFamilyName());
        Assert.assertEquals((String)"FN wrong", (Object)"\u00c4\u00f6\u00df\u00e1\u00e8-\u00dc\u00f8\u00f5\u00e5 test", (Object)card.getFN());
    }
}

