/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.bugs;

import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.carddav.CardDAVTest;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.junit.Assert;
import org.junit.Test;

public class Bug21079Test
extends CardDAVTest {
    @Test
    public void testCheckWriteContentPrivilige() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.CURRENT_USER_PRIVILEGE_SET);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/carddav/", 0, props, 1);
        MultiStatusResponse[] responses = super.getWebDAVClient().doPropFind(propFind);
        Assert.assertNotNull((String)"got no response", (Object)responses);
        Assert.assertTrue((String)"got no responses", (0 < responses.length ? 1 : 0) != 0);
        boolean canWriteContent = false;
        for (MultiStatusResponse response : responses) {
            DavProperty property = response.getProperties(200).get(PropertyNames.CURRENT_USER_PRIVILEGE_SET);
            if (null == property) continue;
            CurrentUserPrivilegeSetProperty privilegeSet = new CurrentUserPrivilegeSetProperty(property);
            for (Privilege privilege : privilegeSet.getValue()) {
                if (!Privilege.PRIVILEGE_WRITE_CONTENT.equals(privilege)) continue;
                canWriteContent = true;
                break;
            }
            if (canWriteContent) break;
        }
        Assert.assertTrue((String)"no write-content privilege found", (boolean)canWriteContent);
    }
}

