/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.jackrabbit.webdav.client.methods.XmlRequestEntity;
import org.apache.jackrabbit.webdav.xml.ResultHelper;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class CustomXmlRequestEntity
implements RequestEntity {
    private final ByteArrayOutputStream xml = new ByteArrayOutputStream();

    public CustomXmlRequestEntity(Document xmlDocument, String encoding) throws IOException {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (null != encoding) {
                transformer.setOutputProperty("encoding", encoding);
            }
            transformer.transform(new DOMSource(xmlDocument), ResultHelper.getResult((Result)new StreamResult(this.xml)));
        }
        catch (TransformerException e) {
            LoggerFactory.getLogger(XmlRequestEntity.class).error(e.getMessage());
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            LoggerFactory.getLogger(XmlRequestEntity.class).error(e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public String getContentType() {
        return "text/xml; charset=UTF-8";
    }

    public void writeRequest(OutputStream out) throws IOException {
        this.xml.writeTo(out);
    }

    public long getContentLength() {
        return this.xml.size();
    }
}

