/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug43521Test
extends CalDAVTest {
    private CalendarTestManager manager2;

    @Before
    public void setUp() throws Exception {
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.manager2) {
            this.manager2.cleanUp();
            if (null != this.manager2.getClient()) {
                this.manager2.getClient().logout();
            }
        }
    }

    @Test
    public void testSyncSoleException() throws Exception {
        SyncToken syncToken = new SyncToken(this.fetchSyncToken());
        String uid = Bug43521Test.randomUID();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("last month in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(uid);
        appointment.setTitle("Bug43521Test");
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        appointment.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        this.manager2.insert(appointment);
        Date clientLastModified = this.manager2.getLastModification();
        Appointment exception = new Appointment();
        exception.setTitle("Bug43521Test_edit");
        exception.setObjectID(appointment.getObjectID());
        exception.setRecurrencePosition(2);
        exception.setLastModified(clientLastModified);
        exception.setParentFolderID(appointment.getParentFolderID());
        exception.addParticipant((Participant)new UserParticipant(this.manager2.getClient().getValues().getUserId()));
        exception.addParticipant((Participant)new UserParticipant(new AJAXClient(AJAXClient.User.User3).getValues().getUserId()));
        exception.addParticipant((Participant)new UserParticipant(this.getClient().getValues().getUserId()));
        this.manager2.update(exception);
        clientLastModified = this.getManager().getLastModification();
        Map<String, String> eTags = this.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = this.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug43521Test.assertContains(uid, calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)exception.getTitle(), (Object)iCalResource.getVEvent().getSummary());
    }
}

