/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug25672Test
extends CalDAVTest {
    private CalendarTestManager manager2;

    @Before
    public void setUp() throws Exception {
        this.manager2 = new CalendarTestManager(new AJAXClient(AJAXClient.User.User2));
        this.manager2.setFailOnError(true);
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.manager2) {
            this.manager2.cleanUp();
            if (null != this.manager2.getClient()) {
                this.manager2.getClient().logout();
            }
        }
    }

    @Test
    public void testUpdateWithDeleteExceptions() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("last month in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(Bug25672Test.randomUID());
        appointment.setTitle("Bug25672Test");
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(1);
        appointment.setInterval(1);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        appointment.setEndDate(calendar.getTime());
        appointment.addParticipant((Participant)new UserParticipant(super.getAJAXClient().getValues().getUserId()));
        appointment.setParentFolderID(this.manager2.getPrivateFolder());
        this.manager2.insert(appointment);
        Date clientLastModified = this.manager2.getLastModification();
        Appointment exception = new Appointment();
        exception.setTitle("Bug23167Test_edit");
        exception.setObjectID(appointment.getObjectID());
        exception.setRecurrencePosition(2);
        exception.setLastModified(clientLastModified);
        exception.setParentFolderID(appointment.getParentFolderID());
        this.manager2.delete(exception);
        clientLastModified = this.manager2.getLastModification();
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug25672Test.assertContains(appointment.getUid(), calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"SUMMARY wrong", (Object)appointment.getTitle(), (Object)iCalResource.getVEvent().getSummary());
        Assert.assertNotNull((String)"No EXDATE in iCal found", iCalResource.getVEvent().getExDates());
        Assert.assertEquals((String)"EXDATE wrong", (long)1L, (long)iCalResource.getVEvent().getExDates().size());
        String editedTitle = appointment.getTitle() + "_edit";
        iCalResource.getVEvent().setSummary(editedTitle);
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        appointment = super.getAppointment(appointment.getUid());
        Assert.assertNotNull((String)"appointment not found on server", (Object)appointment);
        Assert.assertEquals((String)"title wrong", (Object)editedTitle, (Object)appointment.getTitle());
    }
}

