/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.caldav.bugs;

import com.openexchange.dav.SyncToken;
import com.openexchange.dav.caldav.CalDAVTest;
import com.openexchange.dav.caldav.ICalResource;
import com.openexchange.dav.caldav.ical.SimpleICal;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.junit.Assert;
import org.junit.Test;

public class Bug23167Test
extends CalDAVTest {
    @Test
    public void testUpdateOldChangeException() throws Exception {
        SyncToken syncToken = new SyncToken(super.fetchSyncToken());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(TimeTools.D("One year ago in the morning", TimeZone.getTimeZone("Europe/Berlin")));
        Appointment appointment = new Appointment();
        appointment.setUid(Bug23167Test.randomUID());
        appointment.setTitle("Bug23167Test");
        appointment.setIgnoreConflicts(true);
        appointment.setRecurrenceType(2);
        appointment.setDays(1 << calendar.get(7) - 1);
        appointment.setInterval(1);
        appointment.setStartDate(calendar.getTime());
        calendar.add(11, 2);
        appointment.setEndDate(calendar.getTime());
        super.create(appointment);
        Date clientLastModified = this.getManager().getLastModification();
        Appointment exception = new Appointment();
        exception.setTitle("Bug23167Test_edit");
        exception.setObjectID(appointment.getObjectID());
        exception.setRecurrencePosition(2);
        exception.setLastModified(clientLastModified);
        exception.setParentFolderID(appointment.getParentFolderID());
        super.getManager().update(exception);
        clientLastModified = this.getManager().getLastModification();
        Map<String, String> eTags = super.syncCollection(syncToken).getETagsStatusOK();
        Assert.assertTrue((String)"no resource changes reported on sync collection", (0 < eTags.size() ? 1 : 0) != 0);
        List<ICalResource> calendarData = super.calendarMultiget(eTags.keySet());
        ICalResource iCalResource = Bug23167Test.assertContains(appointment.getUid(), calendarData);
        Assert.assertNotNull((String)"No VEVENT in iCal found", (Object)iCalResource.getVEvent());
        Assert.assertEquals((String)"No exception found in iCal", (long)2L, (long)iCalResource.getVEvents().size());
        SimpleICal.Component vEventException = null;
        for (SimpleICal.Component vEvent : iCalResource.getVEvents()) {
            Date recurrenceID = vEvent.getRecurrenceID();
            if (null != recurrenceID) {
                Assert.assertEquals((String)"SUMMARY wrong", (Object)exception.getTitle(), (Object)vEvent.getSummary());
                vEventException = vEvent;
                continue;
            }
            Assert.assertEquals((String)"SUMMARY wrong", (Object)appointment.getTitle(), (Object)vEvent.getSummary());
        }
        vEventException.setProperty("SUMMARY", vEventException.getPropertyValue("SUMMARY") + "_edit2");
        vEventException.setProperty("DTSTAMP", Bug23167Test.formatAsUTC(new Date()));
        Assert.assertEquals((String)"response code wrong", (long)201L, (long)super.putICalUpdate(iCalResource));
        List<Appointment> updates = super.getManager().updates(Bug23167Test.parse(this.getDefaultFolderID()), clientLastModified, false);
        Assert.assertNotNull((String)"no updates found on server", updates);
        Assert.assertTrue((String)"no updated appointments on server", (0 < updates.size() ? 1 : 0) != 0);
        exception = null;
        for (Appointment update : updates) {
            if (appointment.getObjectID() == update.getObjectID() || !appointment.getUid().equals(update.getUid())) continue;
            exception = update;
            break;
        }
        Assert.assertNotNull((String)"Exception not found", (Object)exception);
        Assert.assertEquals((String)"Title wrong", (Object)vEventException.getSummary(), (Object)exception.getTitle());
    }
}

