/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.xing;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.xing.actions.NewsFeedRequest;
import com.openexchange.ajax.xing.actions.NewsFeedResponse;
import com.openexchange.ajax.xing.actions.UserFeedRequest;
import com.openexchange.ajax.xing.actions.UserFeedResponse;
import com.openexchange.exception.OXException;
import com.openexchange.xing.UserField;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FeedTest
extends AbstractAJAXSession {
    public FeedTest(String name) throws Exception {
        super(name);
    }

    public void testSimpleNewsFeed() throws OXException, IOException, JSONException {
        NewsFeedRequest request = new NewsFeedRequest(false, -1L, -1L, new int[0], true);
        NewsFeedResponse response = this.client.execute(request);
        FeedTest.assertNotNull((Object)((Object)response));
        JSONObject json = (JSONObject)response.getData();
        FeedTest.assertNotNull((Object)json.getJSONArray("network_activities"));
    }

    public void testNewsFeedWithUserFields() throws OXException, IOException, JSONException {
        int[] uf = new int[]{UserField.FIRST_NAME.ordinal(), UserField.LAST_NAME.ordinal()};
        NewsFeedRequest request = new NewsFeedRequest(false, -1L, -1L, uf, true);
        NewsFeedResponse response = this.client.execute(request);
        FeedTest.assertNotNull((Object)((Object)response));
        JSONObject json = (JSONObject)response.getData();
        JSONArray network_activities = json.getJSONArray("network_activities");
        FeedTest.assertNotNull((Object)network_activities);
        FeedTest.assertTrue((network_activities.length() > 0 ? 1 : 0) != 0);
        JSONObject na1 = network_activities.getJSONObject(0);
        JSONArray objects = na1.getJSONArray("objects");
        FeedTest.assertTrue((objects.length() > 0 ? 1 : 0) != 0);
        JSONObject obj1 = objects.getJSONObject(0);
        JSONObject person = obj1.getString("type").equals("user") ? obj1 : obj1.getJSONObject("creator");
        FeedTest.assertTrue((boolean)person.hasAndNotNull("id"));
        FeedTest.assertTrue((boolean)person.hasAndNotNull("last_name"));
        FeedTest.assertTrue((boolean)person.hasAndNotNull("first_name"));
        FeedTest.assertFalse((boolean)person.hasAndNotNull("active_email"));
        FeedTest.assertFalse((boolean)person.hasAndNotNull("wants"));
    }

    public void testNewsFeedWithSinceAndUntil() throws OXException, IOException, JSONException {
        NewsFeedRequest request = new NewsFeedRequest(true, 123L, 123L, new int[0], false);
        NewsFeedResponse response = this.client.execute(request);
        FeedTest.assertNotNull((Object)((Object)response));
        FeedTest.assertEquals((String)"XING-0021", (String)response.getException().getErrorCode());
    }

    public void testUserFeedSimple() throws OXException, IOException, JSONException {
        UserFeedRequest request = new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, new int[0], true);
        UserFeedResponse response = this.client.execute(request);
        FeedTest.assertNotNull((Object)((Object)response));
    }

    public void testUserFeedWithUserFields() throws OXException, IOException, JSONException {
        int[] uf = new int[]{UserField.DISPLAY_NAME.ordinal()};
        UserFeedRequest request = new UserFeedRequest("dimitribronkowitsch@googlemail.com", -1L, -1L, uf, true);
        UserFeedResponse response = this.client.execute(request);
        FeedTest.assertNotNull((Object)((Object)response));
    }

    public void testUserFeedBetweenAndUntil() throws OXException, IOException, JSONException {
        int[] uf = new int[]{UserField.DISPLAY_NAME.ordinal()};
        UserFeedRequest request = new UserFeedRequest("dimitribronkowitsch@googlemail.com", 123L, 123L, uf, false);
        UserFeedResponse response = this.client.execute(request);
        FeedTest.assertNotNull((Object)((Object)response));
        FeedTest.assertEquals((String)"XING-0021", (String)response.getException().getErrorCode());
    }
}

