/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user;

import com.meterware.httpunit.WebConversation;
import com.openexchange.ajax.UserTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.user.UserImpl4Test;
import com.openexchange.ajax.user.UserResolver;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.ajax.user.actions.SearchRequest;
import com.openexchange.ajax.user.actions.SearchResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.search.ContactSearchObject;
import java.io.IOException;
import org.json.JSONException;
import org.junit.Assert;
import org.xml.sax.SAXException;

public final class UserTools
extends Assert {
    public static UserImpl4Test[] searchUser(WebConversation webCon, String host, String searchpattern, String session) throws OXException, IOException, SAXException, JSONException {
        ContactSearchObject search = new ContactSearchObject();
        search.setPattern(searchpattern);
        search.addFolder(6);
        SearchRequest request = new SearchRequest(search, UserTest.CONTACT_FIELDS);
        AJAXClient client = new AJAXClient(new AJAXSession(webCon, host, session), false);
        SearchResponse response = Executor.execute(client, request);
        UserTools.assertNotNull((String)"timestamp", (Object)response.getTimestamp());
        return response.getUser();
    }

    public static Contact getUserContact(WebConversation webCon, String host, String session, int userId) throws OXException, IOException, SAXException, JSONException {
        AJAXClient client = new AJAXClient(new AJAXSession(webCon, host, session), false);
        client.setHostname(host);
        GetRequest request = new GetRequest(userId, client.getValues().getTimeZone());
        GetResponse response = client.execute(request);
        return response.getContact();
    }

    public static User getUser(WebConversation webCon, String host, String session, int userId) throws OXException, IOException, SAXException, JSONException {
        AJAXClient client = new AJAXClient(new AJAXSession(webCon, host, session), false);
        client.setHostname(host);
        return new UserResolver(client).getUser(userId);
    }
}

