/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.user;

import com.openexchange.ajax.config.AttributeWriter;
import com.openexchange.ajax.config.BetaWriter;
import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.user.actions.SetAttributeRequest;
import com.openexchange.ajax.user.actions.SetAttributeResponse;
import com.openexchange.exception.OXException;
import com.openexchange.java.Autoboxing;
import com.openexchange.java.util.TimeZones;
import com.openexchange.tools.RandomString;
import java.util.Random;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class Bug26354Test
extends AbstractAJAXSession {
    private static final String ATTRIBUTE_NAME = "testForBug26354";
    private static final int ITERATIONS = 100;
    private static final TimeZone[] TIME_ZONES = new TimeZone[3];
    private final AttributeWriter[] writer = new AttributeWriter[2];
    private final Thread[] thread = new Thread[this.writer.length];
    private AJAXClient client;
    private int userId;
    private boolean origBetaValue;
    private String origTimeZoneValue;

    public Bug26354Test(String name) {
        super(name);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.userId = this.client.getValues().getUserId();
        this.origBetaValue = this.client.execute(new GetRequest(Tree.Beta)).getBoolean();
        this.origTimeZoneValue = this.client.execute(new GetRequest(Tree.TimeZone)).getString();
        this.writer[0] = new BetaWriter(AJAXClient.User.User1);
        this.thread[0] = new Thread(this.writer[0]);
        this.writer[1] = new AttributeWriter(Tree.TimeZone, AJAXClient.User.User1){
            private final Random r;
            {
                this.r = new Random();
            }

            @Override
            protected Object getValue() {
                return TIME_ZONES[this.r.nextInt(3)].getID();
            }
        };
        this.thread[1] = new Thread(this.writer[1]);
        for (int i = 0; i < this.thread.length; ++i) {
            this.thread[i].start();
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        int i;
        for (i = 0; i < this.writer.length; ++i) {
            this.writer[i].stop();
        }
        for (i = 0; i < this.thread.length; ++i) {
            this.thread[i].join();
        }
        for (i = 0; i < this.writer.length; ++i) {
            Throwable throwable = this.writer[i].getThrowable();
            Bug26354Test.assertNull((String)("Expected no Throwable, but there is one: " + throwable), (Object)throwable);
        }
        this.client.execute(new SetRequest(Tree.Beta, Autoboxing.B((boolean)this.origBetaValue)));
        this.client.execute(new SetRequest(Tree.TimeZone, this.origTimeZoneValue));
        Bug26354Test.assertTrue((String)"Deleting the test attribute failed.", (boolean)this.client.execute(new SetAttributeRequest(this.userId, ATTRIBUTE_NAME, null, false)).isSuccess());
        super.tearDown();
    }

    @Test
    public void testForDeadlocks() throws Throwable {
        boolean stop = false;
        for (int i = 0; i < 100 && !stop; ++i) {
            String value = RandomString.generateChars(64);
            SetAttributeResponse response = this.client.execute(new SetAttributeRequest(this.userId, ATTRIBUTE_NAME, value, false, false));
            if (response.hasError()) {
                OXException e = response.getException();
                String logMessage = e.getLogMessage();
                Bug26354Test.assertFalse((String)"Bug 26354 appears again. Deadlock in database detected.", (boolean)logMessage.contains("Deadlock"));
            }
            Bug26354Test.assertTrue((String)"Setting the attribute was not successful.", (boolean)response.isSuccess());
            for (int j = 0; j < this.writer.length; ++j) {
                stop = stop || null != this.writer[j].getThrowable();
            }
        }
    }

    static {
        Bug26354Test.TIME_ZONES[0] = TimeZones.PST;
        Bug26354Test.TIME_ZONES[1] = TimeZones.UTC;
        Bug26354Test.TIME_ZONES[2] = TimeZones.EET;
    }
}

