/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.task;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractUpdatesRequest;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.ajax.framework.MultipleRequest;
import com.openexchange.ajax.framework.MultipleResponse;
import com.openexchange.ajax.task.AbstractTaskTest;
import com.openexchange.ajax.task.TaskTools;
import com.openexchange.ajax.task.actions.AllRequest;
import com.openexchange.ajax.task.actions.DeleteRequest;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.ajax.task.actions.TaskUpdatesResponse;
import com.openexchange.ajax.task.actions.UpdateRequest;
import com.openexchange.ajax.task.actions.UpdateResponse;
import com.openexchange.ajax.task.actions.UpdatesRequest;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.search.Order;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;

public class UpdatesTest
extends AbstractTaskTest {
    private static final int UNTOUCHED = 3;
    private static final int UPDATES = 5;
    private static final int DELETES = 2;

    public UpdatesTest(String name) {
        super(name);
    }

    public void testUpdates() throws Throwable {
        int total = 10;
        AJAXClient client = this.getClient();
        int folderId = client.getValues().getPrivateTaskFolder();
        int userId = client.getValues().getUserId();
        TimeZone timeZone = client.getValues().getTimeZone();
        InsertRequest[] inserts = new InsertRequest[10];
        HashSet<Integer> expectedUpdatedTaskIds = new HashSet<Integer>(5);
        HashSet<Integer> expectedDeletedTaskIds = new HashSet<Integer>(2);
        for (int i = 0; i < inserts.length; ++i) {
            Task task = new Task();
            task.setParentFolderID(folderId);
            task.setTitle("Task " + (i + 1));
            task.setParticipants(new Participant[]{new UserParticipant(userId)});
            inserts[i] = new InsertRequest(task, timeZone);
        }
        MultipleResponse mInsert = (MultipleResponse)client.execute(MultipleRequest.create(inserts));
        int[] columns = new int[]{200, 1, 20};
        CommonAllResponse allR = TaskTools.all(client, new AllRequest(folderId, columns, 200, Order.ASCENDING));
        UpdatesTest.assertTrue((String)"Can't find 10 inserted tasks.", (allR.getArray().length >= 10 ? 1 : 0) != 0);
        UpdateRequest[] updates = new UpdateRequest[5];
        for (int i = 0; i < updates.length; ++i) {
            Task task = new Task();
            task.setTitle("UpdatedTask " + (i + 1));
            InsertResponse insertR = (InsertResponse)((Object)mInsert.getResponse(i));
            task.setObjectID(insertR.getId());
            expectedUpdatedTaskIds.add(insertR.getId());
            task.setParentFolderID(folderId);
            task.setLastModified(insertR.getTimestamp());
            updates[i] = new UpdateRequest(task, timeZone);
        }
        MultipleResponse mUpdate = (MultipleResponse)client.execute(MultipleRequest.create(updates));
        DeleteRequest[] deletes = new DeleteRequest[2];
        for (int i = 0; i < deletes.length; ++i) {
            InsertResponse insertR = (InsertResponse)((Object)mInsert.getResponse(10 - (i + 1)));
            deletes[i] = new DeleteRequest(folderId, insertR.getId(), insertR.getTimestamp());
            expectedDeletedTaskIds.add(insertR.getId());
        }
        client.execute(MultipleRequest.create(deletes));
        columns = new int[]{1, 20, 200, 201, 202, 301, 309, 220};
        TaskUpdatesResponse updatesR = client.execute(new UpdatesRequest(folderId, columns, 0, null, allR.getTimestamp(), AbstractUpdatesRequest.Ignore.NONE));
        UpdatesTest.assertTrue((String)("Only found " + updatesR.size() + " updated tasks but should be more than " + 7 + '.'), (updatesR.size() >= 7 ? 1 : 0) != 0);
        Set<Integer> newOrModifiedIds = updatesR.getNewOrModifiedIds();
        Set<Integer> deletedIds = updatesR.getDeletedIds();
        UpdatesTest.assertTrue((boolean)newOrModifiedIds.containsAll(expectedUpdatedTaskIds));
        UpdatesTest.assertTrue((boolean)deletedIds.containsAll(expectedDeletedTaskIds));
        DeleteRequest[] deletes2 = new DeleteRequest[8];
        for (int i = 0; i < deletes2.length; ++i) {
            InsertResponse insertR = (InsertResponse)((Object)mInsert.getResponse(i));
            Date lastModified = i < 5 ? ((UpdateResponse)((Object)mUpdate.getResponse(i))).getTimestamp() : insertR.getTimestamp();
            deletes2[i] = new DeleteRequest(folderId, insertR.getId(), lastModified);
        }
        client.execute(MultipleRequest.create(deletes2));
    }
}

