/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.subscribe.source.action;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.subscribe.source.action.AbstractSubscriptionSourceRequest;
import com.openexchange.ajax.subscribe.source.action.ListSourcesResponse;
import com.openexchange.java.Strings;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONException;

public class ListSourcesRequest
extends AbstractSubscriptionSourceRequest<ListSourcesResponse> {
    private final String module;
    private List<String> columns;

    public ListSourcesRequest(String module) {
        this.module = module;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        LinkedList<AJAXRequest.Parameter> params = new LinkedList<AJAXRequest.Parameter>();
        params.add(new AJAXRequest.Parameter("action", "listSources"));
        if (this.module != null) {
            params.add(new AJAXRequest.Parameter("module", this.module));
        }
        if (this.getColumns() != null) {
            params.add(new AJAXRequest.Parameter("columns", Strings.join(this.getColumns(), (String)",")));
        }
        return params.toArray(new AJAXRequest.Parameter[0]);
    }

    @Override
    public AbstractAJAXParser<? extends ListSourcesResponse> getParser() {
        return new AbstractAJAXParser<ListSourcesResponse>(this.getFailOnError()){

            @Override
            protected ListSourcesResponse createResponse(Response response) throws JSONException {
                return new ListSourcesResponse(response);
            }
        };
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return null;
    }
}

