/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.ajax.user.actions.UpdateRequest;
import com.openexchange.ajax.user.actions.UpdateResponse;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.ldap.User;

public class GuestContactTest
extends ShareTest {
    public GuestContactTest(String name) {
        super(name);
    }

    public void testCreateGuestContact() throws Exception {
        String guestName = GuestContactTest.randomUID();
        String guestMail = guestName + "@example.com";
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8));
        FileStorageGuestObjectPermission guestPermission = GuestContactTest.asObjectPermission(GuestContactTest.createNamedGuestPermission(guestMail, guestName));
        File file = this.insertSharedFile(folder.getObjectID(), (FileStorageObjectPermission)guestPermission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        GuestContactTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        GuestContactTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        GuestContactTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestContactTest.assertTrue((String)"Guest id must not be -1", (guest.getEntity() > -1 ? 1 : 0) != 0);
        GuestClient guestClient = this.resolveShare(this.discoverShareURL(guest), guestPermission.getRecipient());
        GetRequest guestGetRequest = new GetRequest(guest.getEntity(), guestClient.getValues().getTimeZone());
        GetResponse guestGetResponse = guestClient.execute(guestGetRequest);
        Contact guestContact = guestGetResponse.getContact();
        GetRequest getRequest = new GetRequest(guest.getEntity(), this.client.getValues().getTimeZone());
        GetResponse getResponse = this.client.execute(getRequest);
        Contact contact = getResponse.getContact();
        GuestContactTest.assertEquals((String)"Contacts does not match", (Object)contact, (Object)guestContact);
        GuestContactTest.assertNotNull((String)"Contact is null.", (Object)contact);
        GuestContactTest.assertEquals((String)"Wrong display name.", (String)guestName, (String)contact.getDisplayName());
        GuestContactTest.assertEquals((String)"Wrong email address.", (String)guestMail, (String)contact.getEmail1());
        GuestContactTest.assertTrue((String)"Contact id is 0.", (contact.getObjectID() != 0 ? 1 : 0) != 0);
    }

    public void testUpdateGuestContact() throws Exception {
        String guestName = GuestContactTest.randomUID();
        String guestMail = guestName + "@example.com";
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8));
        FileStorageGuestObjectPermission guestPermission = GuestContactTest.asObjectPermission(GuestContactTest.createNamedGuestPermission(guestMail, guestName));
        File file = this.insertSharedFile(folder.getObjectID(), (FileStorageObjectPermission)guestPermission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        GuestContactTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        GuestContactTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        GuestContactTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestContactTest.assertTrue((String)"Guest id must not be -1", (guest.getEntity() > -1 ? 1 : 0) != 0);
        GuestClient guestClient = this.resolveShare(this.discoverShareURL(guest), guestPermission.getRecipient());
        GetRequest guestGetRequest = new GetRequest(guest.getEntity(), guestClient.getValues().getTimeZone());
        GetResponse guestGetResponse = guestClient.execute(guestGetRequest);
        Contact guestContact = guestGetResponse.getContact();
        User guestUser = guestGetResponse.getUser();
        guestContact.setDisplayName(guestName + "_modified");
        UpdateRequest updateRequest = new UpdateRequest(guestContact, guestUser);
        UpdateResponse updateResponse = guestClient.execute(updateRequest);
        GuestContactTest.assertFalse((String)updateResponse.getErrorMessage(), (boolean)updateResponse.hasError());
        GetRequest getRequest = new GetRequest(guest.getEntity(), this.client.getValues().getTimeZone());
        GetResponse getResponse = this.client.execute(getRequest);
        Contact contact = getResponse.getContact();
        GuestContactTest.assertEquals((String)"Display name was not updated", (String)(guestName + "_modified"), (String)contact.getDisplayName());
        contact.setDisplayName(guestName);
        UpdateRequest updateRequest2 = new UpdateRequest(guestContact, guestUser, false);
        UpdateResponse updateResponse2 = this.client.execute(updateRequest2);
        GuestContactTest.assertTrue((String)"Client was able to update foreign contact.", (boolean)updateResponse2.hasError());
        GuestContactTest.assertEquals((int)ContactExceptionCodes.NO_CHANGE_PERMISSION.getNumber(), (int)updateResponse2.getException().getCode());
    }

    public void testOtherUser() throws Exception {
        String guestName = GuestContactTest.randomUID();
        String guestMail = guestName + "@example.com";
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.getDefaultFolder(8));
        FileStorageGuestObjectPermission guestPermission = GuestContactTest.asObjectPermission(GuestContactTest.createNamedGuestPermission(guestMail, guestName));
        File file = this.insertSharedFile(folder.getObjectID(), (FileStorageObjectPermission)guestPermission);
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        GuestContactTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        GuestContactTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        GuestContactTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestContactTest.assertTrue((String)"Guest id must not be -1", (guest.getEntity() > -1 ? 1 : 0) != 0);
        AJAXClient secondClient = new AJAXClient(AJAXClient.User.User2);
        GetRequest getRequest = new GetRequest(guest.getEntity(), secondClient.getValues().getTimeZone());
        GetResponse getResponse = secondClient.execute(getRequest);
        GuestContactTest.assertFalse((String)"Contact could not be loaded.", (boolean)getResponse.hasError());
        Contact contact = getResponse.getContact();
        User user = getResponse.getUser();
        GuestContactTest.assertEquals((String)"Wrong contact loaded.", (String)guestName, (String)contact.getDisplayName());
        GuestContactTest.assertEquals((String)"Wrong contact loaded.", (String)guestMail, (String)contact.getEmail1());
        contact.setDisplayName("This should not work");
        UpdateRequest updateRequest = new UpdateRequest(contact, user, false);
        UpdateResponse updateResponse = secondClient.execute(updateRequest);
        GuestContactTest.assertTrue((String)"Any user can change contact data.", (boolean)updateResponse.hasError());
        GuestContactTest.assertEquals((int)ContactExceptionCodes.NO_CHANGE_PERMISSION.getNumber(), (int)updateResponse.getException().getCode());
        DeleteRequest deleteRequest = new DeleteRequest(contact, false);
        CommonDeleteResponse deleteResponse = secondClient.execute(deleteRequest);
        GuestContactTest.assertTrue((String)"Any user can delete any shares.", (boolean)deleteResponse.hasError());
    }
}

