/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateRequest;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateResponse;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.java.util.UUIDs;
import com.openexchange.server.impl.OCLPermission;
import java.util.Collections;

public class EmptyGuestPasswordTest
extends ShareTest {
    private FolderObject folder;

    public EmptyGuestPasswordTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        EmptyGuestPasswordTest.deleteFoldersSilently(this.client, Collections.singletonList(this.folder.getObjectID()));
        super.tearDown();
    }

    public void testEmptyPassword() throws Exception {
        long now = System.currentTimeMillis();
        OCLGuestPermission perm = EmptyGuestPasswordTest.createNamedGuestPermission("testGuestPasswordInit" + now + "@example.org", "Test " + now);
        this.folder = this.insertSharedFolder(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.client.getValues().getPrivateInfostoreFolder(), perm);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : this.folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        EmptyGuestPasswordTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        EmptyGuestPasswordTest.checkPermissions(perm, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OX_NEW, Module.INFOSTORE.getFolderConstant(), this.folder.getObjectID(), matchingPermission.getEntity());
        EmptyGuestPasswordTest.checkGuestPermission(perm, guest);
        String shareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(shareURL);
        EmptyGuestPasswordTest.assertNull((Object)((Object)guestClient.getLoginResponse()));
        String newPW = UUIDs.getUnformattedStringFromRandom();
        PasswordChangeUpdateRequest pwChangeReq = new PasswordChangeUpdateRequest(newPW, "", true);
        PasswordChangeUpdateResponse pwChangeResp = guestClient.execute(pwChangeReq);
        EmptyGuestPasswordTest.assertFalse((boolean)pwChangeResp.hasWarnings());
        EmptyGuestPasswordTest.assertFalse((boolean)pwChangeResp.hasError());
        guestClient.logout();
        guestClient = this.resolveShare(shareURL, ShareTest.getUsername(perm.getRecipient()), newPW);
        LoginResponse response = guestClient.getLoginResponse();
        EmptyGuestPasswordTest.assertNotNull((Object)((Object)response));
        EmptyGuestPasswordTest.assertFalse((boolean)response.hasError());
        EmptyGuestPasswordTest.assertNotNull((Object)response.getSessionId());
        guestClient = this.resolveShare(shareURL);
        response = guestClient.getLoginResponse();
        EmptyGuestPasswordTest.assertNotNull((Object)((Object)response));
        EmptyGuestPasswordTest.assertTrue((boolean)response.hasError());
    }
}

