/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateRequest;
import com.openexchange.ajax.passwordchange.actions.PasswordChangeUpdateResponse;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.share.actions.UpdateLinkRequest;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.RecipientType;

public class AnonymousGuestPasswordTest
extends ShareTest {
    public AnonymousGuestPasswordTest(String name) {
        super(name);
    }

    public void testUpdatePasswordForAnonymousGuest() throws Exception {
        OCLGuestPermission guestPermission = AnonymousGuestPasswordTest.createAnonymousGuestPermission();
        int module = AnonymousGuestPasswordTest.randomModule();
        EnumAPI api = AnonymousGuestPasswordTest.randomFolderAPI();
        FolderObject folder = this.insertSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        AnonymousGuestPasswordTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        AnonymousGuestPasswordTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        AnonymousGuestPasswordTest.checkGuestPermission(guestPermission, guest);
        AnonymousGuestPasswordTest.assertEquals((Object)RecipientType.ANONYMOUS, (Object)guest.getType());
        AnonymousGuestPasswordTest.assertNull((String)"Password is set", (Object)guest.getPassword());
        UpdateLinkRequest updateLinkRequest = new UpdateLinkRequest(new ShareTarget(module, String.valueOf(folder.getObjectID())), this.client.getValues().getTimeZone(), System.currentTimeMillis());
        updateLinkRequest.setPassword("secret");
        ((AnonymousRecipient)guestPermission.getRecipient()).setPassword("secret");
        this.client.execute(updateLinkRequest);
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        AnonymousGuestPasswordTest.checkGuestPermission(guestPermission, guest);
        AnonymousGuestPasswordTest.assertEquals((Object)RecipientType.ANONYMOUS, (Object)guest.getType());
        AnonymousGuestPasswordTest.assertNotNull((String)"Password not set", (Object)guest.getPassword());
        AnonymousGuestPasswordTest.assertEquals((String)"Password wrong", (String)"secret", (String)guest.getPassword());
        updateLinkRequest.setPassword("geheim");
        ((AnonymousRecipient)guestPermission.getRecipient()).setPassword("geheim");
        this.client.execute(updateLinkRequest);
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        AnonymousGuestPasswordTest.checkGuestPermission(guestPermission, guest);
        AnonymousGuestPasswordTest.assertEquals((Object)RecipientType.ANONYMOUS, (Object)guest.getType());
        AnonymousGuestPasswordTest.assertNotNull((String)"Password not set", (Object)guest.getPassword());
        AnonymousGuestPasswordTest.assertEquals((String)"Password wrong", (String)"geheim", (String)guest.getPassword());
        updateLinkRequest.setPassword(null);
        ((AnonymousRecipient)guestPermission.getRecipient()).setPassword(null);
        this.client.execute(updateLinkRequest);
        guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        AnonymousGuestPasswordTest.checkGuestPermission(guestPermission, guest);
        AnonymousGuestPasswordTest.assertEquals((Object)RecipientType.ANONYMOUS, (Object)guest.getType());
        AnonymousGuestPasswordTest.assertNull((String)"Password is set", (Object)guest.getPassword());
    }

    public void testDontAllowAnonymousGuestPasswordUpdate() throws Exception {
        OCLGuestPermission guestPermission = AnonymousGuestPasswordTest.createAnonymousGuestPermission("secret");
        int module = AnonymousGuestPasswordTest.randomModule();
        EnumAPI api = AnonymousGuestPasswordTest.randomFolderAPI();
        FolderObject folder = this.insertSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        AnonymousGuestPasswordTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        AnonymousGuestPasswordTest.checkPermissions(guestPermission, matchingPermission);
        guestPermission.setEntity(matchingPermission.getEntity());
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        AnonymousGuestPasswordTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        String newPassword = "secret2";
        PasswordChangeUpdateRequest updateRequest = new PasswordChangeUpdateRequest(newPassword, ((AnonymousRecipient)guestPermission.getRecipient()).getPassword(), false);
        PasswordChangeUpdateResponse response = guestClient.execute(updateRequest);
        AnonymousGuestPasswordTest.assertTrue((String)"No errors in response", (boolean)response.hasError());
        guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        GuestClient revokedGuestClient = new GuestClient(guest.getShareURL(), null, newPassword, false);
        AnonymousGuestPasswordTest.assertTrue((String)"No errors during login with new password", (boolean)revokedGuestClient.getLoginResponse().hasError());
        AnonymousGuestPasswordTest.assertNull((String)"Got session ID from login with new password", (Object)revokedGuestClient.getLoginResponse().getSessionId());
    }
}

