/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.tests;

import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AddGuestPermissionTest
extends ShareTest {
    public AddGuestPermissionTest(String name) {
        super(name);
    }

    public void testUpdateSharedFolderRandomly() throws Exception {
        int module = AddGuestPermissionTest.randomModule();
        this.testUpdateSharedFolder(AddGuestPermissionTest.randomFolderAPI(), module, AddGuestPermissionTest.randomGuestPermission(module));
    }

    public void noTestUpdateSharedFolderExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (OCLGuestPermission guestPermission : TESTED_PERMISSIONS) {
                for (int module : TESTED_MODULES) {
                    this.testUpdateSharedFolder(api, module, guestPermission);
                }
            }
        }
    }

    public void testUpdateSharedFileRandomly() throws Exception {
        this.testUpdateSharedFile(AddGuestPermissionTest.randomFolderAPI(), AddGuestPermissionTest.randomGuestObjectPermission());
    }

    public void noTestUpdateSharedFileExtensively() throws Exception {
        for (FileStorageGuestObjectPermission guestPermission : TESTED_OBJECT_PERMISSIONS) {
            this.testUpdateSharedFile(AddGuestPermissionTest.randomFolderAPI(), guestPermission);
        }
    }

    public void testUpdateSharedFolderWithCascadingPermissionsRandomly() throws Exception {
        int module = AddGuestPermissionTest.randomModule();
        this.testUpdateSharedFolderWithCascadingPermissions(AddGuestPermissionTest.randomFolderAPI(), module, this.getDefaultFolder(module), AddGuestPermissionTest.randomGuestPermission(module));
    }

    public void noTestUpdateSharedFolderWithCascadingPermissionsExtensively() throws Exception {
        for (EnumAPI api : TESTED_FOLDER_APIS) {
            for (OCLGuestPermission guestPermission : TESTED_PERMISSIONS) {
                for (int module : TESTED_MODULES) {
                    this.testUpdateSharedFolderWithCascadingPermissions(api, module, this.getDefaultFolder(module), guestPermission);
                }
            }
        }
    }

    private void testUpdateSharedFolder(EnumAPI api, int module, OCLGuestPermission guestPermission) throws Exception {
        this.testUpdateSharedFolder(api, module, this.getDefaultFolder(module), guestPermission);
    }

    private void testUpdateSharedFolder(EnumAPI api, int module, int parent, OCLGuestPermission guestPermission) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, module, parent);
        folder.addPermission((OCLPermission)guestPermission);
        folder = this.updateFolder(api, folder);
        OCLPermission matchingPermission = null;
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        AddGuestPermissionTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
        AddGuestPermissionTest.checkPermissions(guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, folder.getObjectID(), matchingPermission.getEntity());
        AddGuestPermissionTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }

    private void testUpdateSharedFolderWithCascadingPermissions(EnumAPI api, int module, int parent, OCLGuestPermission guestPermission) throws Exception {
        FolderObject rootFolder = this.insertPrivateFolder(api, module, parent, "Root_" + AddGuestPermissionTest.randomUID());
        FolderObject subLevel1 = this.insertPrivateFolder(api, module, rootFolder.getObjectID(), "Sub1" + AddGuestPermissionTest.randomUID());
        FolderObject subLevel2 = this.insertPrivateFolder(api, module, subLevel1.getObjectID(), "Sub2" + AddGuestPermissionTest.randomUID());
        Date clientLastModified = subLevel2.getLastModified();
        rootFolder.addPermission((OCLPermission)guestPermission);
        rootFolder.setLastModified(clientLastModified);
        rootFolder = this.updateFolder(api, rootFolder, true);
        subLevel1 = this.getFolder(api, subLevel1.getObjectID());
        subLevel2 = this.getFolder(api, subLevel1.getObjectID());
        OCLPermission matchingRootPermission = null;
        for (FolderObject folder : new FolderObject[]{rootFolder, subLevel1, subLevel2}) {
            OCLPermission matchingPermission = null;
            List permissions = folder.getPermissions();
            AddGuestPermissionTest.assertNotNull((String)("No permissions fround for folder " + folder.getObjectID()), (Object)permissions);
            AddGuestPermissionTest.assertEquals((String)("Wrong number of permissions on folder " + folder.getObjectID()), (int)2, (int)permissions.size());
            for (OCLPermission permission : permissions) {
                if (permission.getEntity() == this.client.getValues().getUserId()) continue;
                matchingPermission = permission;
                break;
            }
            AddGuestPermissionTest.assertNotNull((String)"No matching permission in created folder found", matchingPermission);
            AddGuestPermissionTest.checkPermissions(guestPermission, matchingPermission);
            if (folder == rootFolder) {
                matchingRootPermission = matchingPermission;
                continue;
            }
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission entity for subfolder " + folder.getObjectID()), (int)matchingRootPermission.getEntity(), (int)matchingPermission.getEntity());
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission bits for subfolder " + folder.getObjectID()), (int)matchingRootPermission.getReadPermission(), (int)matchingPermission.getReadPermission());
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission bits for subfolder " + folder.getObjectID()), (int)matchingRootPermission.getWritePermission(), (int)matchingPermission.getWritePermission());
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission bits for subfolder " + folder.getObjectID()), (int)matchingRootPermission.getDeletePermission(), (int)matchingPermission.getDeletePermission());
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission bits for subfolder " + folder.getObjectID()), (int)matchingRootPermission.getFolderPermission(), (int)matchingPermission.getFolderPermission());
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission bits for subfolder " + folder.getObjectID()), (int)matchingRootPermission.getSystem(), (int)matchingPermission.getSystem());
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission bits for subfolder " + folder.getObjectID()), (boolean)matchingRootPermission.isFolderAdmin(), (boolean)matchingPermission.isFolderAdmin());
            AddGuestPermissionTest.assertEquals((String)("Unexpected permission bits for subfolder " + folder.getObjectID()), (boolean)matchingRootPermission.isGroupPermission(), (boolean)matchingPermission.isGroupPermission());
        }
        ExtendedPermissionEntity guest = this.discoverGuestEntity(api, module, rootFolder.getObjectID(), matchingRootPermission.getEntity());
        AddGuestPermissionTest.checkGuestPermission(guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }

    private void testUpdateSharedFile(EnumAPI api, FileStorageGuestObjectPermission guestPermission) throws Exception {
        this.testUpdateSharedFile(api, this.getDefaultFolder(8), guestPermission);
    }

    private void testUpdateSharedFile(EnumAPI api, int parent, FileStorageGuestObjectPermission guestPermission) throws Exception {
        FolderObject folder = this.insertPrivateFolder(api, 8, parent);
        File file = this.insertFile(folder.getObjectID());
        file.setObjectPermissions(Collections.singletonList(guestPermission));
        file = this.updateFile(file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
        FileStorageObjectPermission matchingPermission = null;
        for (FileStorageObjectPermission permission : file.getObjectPermissions()) {
            if (permission.getEntity() == this.client.getValues().getUserId()) continue;
            matchingPermission = permission;
            break;
        }
        AddGuestPermissionTest.assertNotNull((String)"No matching permission in created file found", matchingPermission);
        AddGuestPermissionTest.checkPermissions((FileStorageObjectPermission)guestPermission, matchingPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(file.getFolderId(), file.getId(), matchingPermission.getEntity());
        AddGuestPermissionTest.checkGuestPermission((FileStorageObjectPermission)guestPermission, guest);
        GuestClient guestClient = this.resolveShare(guest, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
    }
}

