/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.google.common.io.BaseEncoding;
import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.OCLGuestPermission;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.ajax.share.actions.ExtendedPermissionEntity;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.ajax.user.actions.UpdateRequest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.ldap.User;
import com.openexchange.server.impl.OCLPermission;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;

public class Bug41537Test
extends ShareTest {
    private static final String CONTACT_IMAGE = "iVBORw0KGgoAAAANSUhEUgAAAEwAAABMCAMAAADwSaEZAAAAAXNSR0IArs4c6QAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9wEDAgrFQPAJ7YAAAAidEVYdENvbW1lbnQAQ3JlYXRlZCB3aXRoIEdJTVAgb24gYSBNYWOHqHdDAAAAUVBMVEUAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAD///9cFzNQAAAAGnRSTlMAAQIDBAUGBwgJCgsMDQ4PEBESExQVFhcYGXTAuKUAAAABYktHRBp1Z+QyAAABNklEQVRYw+3X3Y6EIAwF4OLPrAq4KjDlvP+L7tUmsztCLHIzCecBvkCNbSH61KjRHIEBDocZ1T1qcXiJW25w4x8KANxYak2Mt/BUaEWcJBZpI+M0XHLTHYnsBZdEMlO9gxUcrUcmvRCbc9gsxNYcttYrmbxoLoc5IeZzmBdiIYeFhjWsYbX+zVCza0h/9C2HbUJM5zAtHSgxbUXpQMkNASvfptITvWCvUse5dRRtQfa0XgWXTFYtiodmwxrWsGFNPSpW6avi8Z1t21N3vfnM2Y0WAJy+1m077XEhTztcKNUTF8NbvniPDaIcX6kWrqYd4rjl7Fso7VAUr/9znfEoTjCvXGcZt8L2l1PmJgUAbBQR0eBRJX4g6gMqJfTno7YslkI9LBDXw5hiPSwSKqZhDfs8zNWz3A+fuiRwXiy9mwAAAABJRU5ErkJggg==";

    public Bug41537Test(String name) {
        super(name);
    }

    public void testGuestCanUpdateHisContactImage() throws Exception {
        OCLGuestPermission guestPermission = Bug41537Test.createNamedGuestPermission(Bug41537Test.randomUID() + "@example.com", Bug41537Test.randomUID());
        FolderObject folder = this.insertSharedFolder(EnumAPI.OUTLOOK, 8, this.client.getValues().getPrivateInfostoreFolder(), guestPermission);
        OCLPermission guestEntityPermission = this.findFirstGuestPermission(folder);
        Bug41537Test.assertNotNull((Object)guestEntityPermission);
        ExtendedPermissionEntity guest = this.discoverGuestEntity(EnumAPI.OUTLOOK, 8, folder.getObjectID(), guestEntityPermission.getEntity());
        Bug41537Test.checkGuestPermission(guestPermission, guest);
        String folderShareURL = this.discoverShareURL(guest);
        GuestClient guestClient = this.resolveShare(folderShareURL, guestPermission.getRecipient());
        guestClient.checkShareModuleAvailable();
        guestClient.checkShareAccessible(guestPermission);
        TimeZone timeZone = guestClient.getValues().getTimeZone();
        int guestUserId = guestClient.getValues().getUserId();
        User guestUser = guestClient.execute(new GetRequest(guestUserId, timeZone, true)).getUser();
        Contact contact = new Contact();
        contact.setParentFolderID(16);
        contact.setObjectID(guestUser.getContactId());
        contact.setInternalUserId(guestUserId);
        contact.setImageContentType("image/png");
        contact.setLastModified(new Date());
        byte[] imageBytes = BaseEncoding.base64().decode((CharSequence)CONTACT_IMAGE);
        contact.setImage1(imageBytes);
        guestClient.execute(new UpdateRequest(contact, null, true));
        GetResponse reloadResponse = guestClient.execute(new GetRequest(guestUserId, timeZone, true));
        Contact reloaded = reloadResponse.getContact();
        Bug41537Test.assertEquals((String)"No image set in contact", (int)1, (int)reloaded.getNumberOfImages());
        Bug41537Test.assertEquals((String)"Wrong image content type set in contact", (String)"image/png", (String)reloaded.getImageContentType());
        Bug41537Test.assertNotNull((String)"No image set in contact", (Object)reloadResponse.getImageUrl());
        byte[] reloadedImageBytes = AbstractContactTest.loadImageByURL(guestClient, reloadResponse.getImageUrl());
        Bug41537Test.assertTrue((String)"Wrong image set in contact", (boolean)Arrays.equals(imageBytes, reloadedImageBytes));
        reloadResponse = this.client.execute(new GetRequest(guestUserId, timeZone, true));
        reloaded = reloadResponse.getContact();
        Bug41537Test.assertEquals((String)"No image set in contact", (int)1, (int)reloaded.getNumberOfImages());
        Bug41537Test.assertEquals((String)"Wrong image content type set in contact", (String)"image/png", (String)reloaded.getImageContentType());
        Bug41537Test.assertNotNull((String)"No image set in contact", (Object)reloadResponse.getImageUrl());
        reloadedImageBytes = AbstractContactTest.loadImageByURL(this.client, reloadResponse.getImageUrl());
        Bug41537Test.assertTrue((String)"Wrong image set in contact", (boolean)Arrays.equals(imageBytes, reloadedImageBytes));
    }
}

