/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.bugs;

import com.openexchange.ajax.find.AbstractFindTest;
import com.openexchange.ajax.find.PropDocument;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.share.GuestClient;
import com.openexchange.ajax.share.ShareTest;
import com.openexchange.file.storage.DefaultFileStorageObjectPermission;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageGuestObjectPermission;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.find.Module;
import com.openexchange.find.common.CommonFacetType;
import com.openexchange.find.drive.DriveFacetType;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.Facet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.SimpleFacet;
import com.openexchange.groupware.container.FolderObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;

public class Bug40561Test
extends ShareTest {
    public Bug40561Test(String name) {
        super(name);
    }

    public void testShareFileAndSearchForItAsGuest() throws Exception {
        FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
        File file = this.insertFile(folder.getObjectID(), "Tests.zip");
        String guestEmailAddress = Bug40561Test.randomUID() + "@example.com";
        FileStorageGuestObjectPermission guestPermission = Bug40561Test.asObjectPermission(Bug40561Test.createNamedAuthorPermission(guestEmailAddress, Bug40561Test.randomUID()));
        file.setObjectPermissions(Collections.singletonList(guestPermission));
        file = this.updateFile(file, new File.Field[]{File.Field.OBJECT_PERMISSIONS});
        String sharedFolderID = "10";
        FileID tmp = new FileID(file.getId());
        tmp.setFolderId(sharedFolderID);
        String sharedFileID = tmp.toUniqueID();
        GuestClient guestClient = this.resolveShare(this.discoverInvitationLink(this.client, guestEmailAddress));
        guestClient.checkFileAccessible(sharedFolderID, sharedFileID, guestPermission);
        List<Facet> facets = AbstractFindTest.autocomplete(guestClient, Module.DRIVE, "tests");
        ArrayList<ActiveFacet> activeFacets = new ArrayList<ActiveFacet>(2);
        activeFacets.add(AbstractFindTest.createActiveFolderFacet(sharedFolderID));
        activeFacets.add(AbstractFindTest.createActiveFacet((SimpleFacet)AbstractFindTest.findByType((FacetType)DriveFacetType.FILE_NAME, facets)));
        List<PropDocument> searchResults = AbstractFindTest.query(guestClient, Module.DRIVE, activeFacets);
        Assert.assertNotNull((Object)AbstractFindTest.findByProperty(searchResults, "id", sharedFileID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShareFileInternallyAndSearchForIt() throws Exception {
        AJAXClient shareClient = new AJAXClient(AJAXClient.User.User2);
        try {
            FolderObject folder = this.insertPrivateFolder(EnumAPI.OX_NEW, 8, this.client.getValues().getPrivateInfostoreFolder());
            DefaultFileStorageObjectPermission sharePermission = new DefaultFileStorageObjectPermission(shareClient.getValues().getUserId(), false, 1);
            File file = this.insertSharedFile(folder.getObjectID(), "Tests.zip", (FileStorageObjectPermission)sharePermission);
            String sharedFolderID = "10";
            FileID tmp = new FileID(file.getId());
            tmp.setFolderId(sharedFolderID);
            String sharedFileID = tmp.toUniqueID();
            List<Facet> facets = AbstractFindTest.autocomplete(shareClient, Module.DRIVE, "tests");
            ArrayList<ActiveFacet> activeFacets = new ArrayList<ActiveFacet>(2);
            activeFacets.add(AbstractFindTest.createActiveFolderFacet(sharedFolderID));
            activeFacets.add(AbstractFindTest.createActiveFacet((SimpleFacet)AbstractFindTest.findByType((FacetType)CommonFacetType.GLOBAL, facets)));
            List<PropDocument> searchResults = AbstractFindTest.query(shareClient, Module.DRIVE, activeFacets);
            Assert.assertNotNull((Object)AbstractFindTest.findByProperty(searchResults, "id", sharedFileID));
        }
        finally {
            shareClient.logout();
        }
    }
}

