/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.drive.DriveShareTarget;
import com.openexchange.groupware.modules.Module;
import com.openexchange.share.ShareTarget;
import com.openexchange.share.recipient.AnonymousRecipient;
import com.openexchange.share.recipient.GuestRecipient;
import com.openexchange.share.recipient.InternalRecipient;
import com.openexchange.share.recipient.RecipientType;
import com.openexchange.share.recipient.ShareRecipient;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ShareWriter {
    public static JSONArray writeRecipients(List<ShareRecipient> recipients) throws JSONException {
        JSONArray jRecipients = new JSONArray();
        for (ShareRecipient recipient : recipients) {
            jRecipients.put((Object)ShareWriter.writeRecipient(recipient));
        }
        return jRecipients;
    }

    public static JSONObject writeRecipient(ShareRecipient recipient) throws JSONException {
        JSONObject jRecipient = new JSONObject(5);
        RecipientType type = recipient.getType();
        jRecipient.put("type", (Object)type.name().toLowerCase());
        jRecipient.put("bits", recipient.getBits());
        switch (type) {
            case USER: 
            case GROUP: {
                ShareWriter.writeInternalRecipient((InternalRecipient)recipient, jRecipient);
                break;
            }
            case ANONYMOUS: {
                ShareWriter.writeAnonymousRecipient((AnonymousRecipient)recipient, jRecipient);
                break;
            }
            case GUEST: {
                ShareWriter.writeGuestRecipient((GuestRecipient)recipient, jRecipient);
            }
        }
        return jRecipient;
    }

    public static void writeGuestRecipient(GuestRecipient recipient, JSONObject jRecipient) throws JSONException {
        jRecipient.put("email_address", (Object)recipient.getEmailAddress());
        jRecipient.put("override_password", (Object)recipient.getPassword());
        jRecipient.put("display_name", (Object)recipient.getDisplayName());
        jRecipient.put("contact_id", (Object)recipient.getContactID());
        jRecipient.put("contact_folder", (Object)recipient.getContactFolder());
    }

    public static void writeAnonymousRecipient(AnonymousRecipient recipient, JSONObject jRecipient) throws JSONException {
        jRecipient.put("password", (Object)recipient.getPassword());
        jRecipient.put("expiry_date", recipient.getExpiryDate() == null ? null : Long.valueOf(recipient.getExpiryDate().getTime()));
    }

    public static void writeInternalRecipient(InternalRecipient recipient, JSONObject jRecipient) throws JSONException {
        jRecipient.put("entity", recipient.getEntity());
    }

    public static JSONArray writeTargets(List<ShareTarget> targets) throws JSONException {
        JSONArray jTargets = new JSONArray();
        for (ShareTarget target : targets) {
            jTargets.put((Object)ShareWriter.writeTarget(target));
        }
        return jTargets;
    }

    public static JSONObject writeTarget(ShareTarget target) throws JSONException {
        JSONObject jTarget = new JSONObject(6);
        jTarget.put("module", (Object)Module.getModuleString((int)target.getModule(), (int)-1));
        jTarget.put("folder", (Object)target.getFolder());
        jTarget.put("item", (Object)target.getItem());
        return jTarget;
    }

    public static JSONObject writeDriveTarget(DriveShareTarget target) throws JSONException {
        JSONObject jTarget = new JSONObject(6);
        jTarget.put("path", (Object)target.getDrivePath());
        jTarget.putOpt("name", (Object)target.getName());
        jTarget.put("checksum", (Object)target.getChecksum());
        return jTarget;
    }
}

