/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.share.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Header;
import com.openexchange.ajax.framework.Params;
import com.openexchange.ajax.share.actions.GetLinkResponse;
import com.openexchange.ajax.share.actions.ShareLink;
import com.openexchange.ajax.share.actions.ShareWriter;
import com.openexchange.java.util.TimeZones;
import com.openexchange.share.ShareTarget;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class GetLinkRequest
implements AJAXRequest<GetLinkResponse> {
    private final ShareTarget target;
    private final TimeZone timeZone;
    private boolean failOnError = true;

    public GetLinkRequest(ShareTarget target) {
        this.target = target;
        this.timeZone = TimeZones.UTC;
    }

    public GetLinkRequest(ShareTarget target, TimeZone timeZone) {
        this.target = target;
        this.timeZone = timeZone;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public String getServletPath() {
        return "/ajax/share/management";
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new Params("action", "getLink").toArray();
    }

    @Override
    public AbstractAJAXParser<GetLinkResponse> getParser() {
        return new Parser(this.failOnError, this.timeZone);
    }

    @Override
    public Object getBody() throws IOException, JSONException {
        return ShareWriter.writeTarget(this.target);
    }

    @Override
    public Header[] getHeaders() {
        return NO_HEADER;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    private static final class Parser
    extends AbstractAJAXParser<GetLinkResponse> {
        private final TimeZone timeZone;

        protected Parser(boolean failOnError, TimeZone timeZone) {
            super(failOnError);
            this.timeZone = timeZone;
        }

        @Override
        protected GetLinkResponse createResponse(Response response) throws JSONException {
            if (!response.hasError()) {
                JSONObject data = (JSONObject)response.getData();
                ShareLink shareLink = new ShareLink(data, this.timeZone);
                return new GetLinkResponse(response, shareLink);
            }
            return new GetLinkResponse(response, null);
        }
    }
}

