/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session.actions;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.AbstractRequest;
import com.openexchange.ajax.session.actions.TokenLoginParser;
import com.openexchange.ajax.session.actions.TokenLoginResponse;
import com.openexchange.java.util.UUIDs;
import java.util.ArrayList;
import java.util.UUID;

public final class TokenLoginRequest
extends AbstractRequest<TokenLoginResponse> {
    private final String clientToken;

    public TokenLoginRequest(String login, String password, String authId, String client, String version, boolean autologin, String clientToken) {
        this(login, password, authId, client, version, autologin, clientToken, false);
    }

    public TokenLoginRequest(String login, String password, String authId, String client, String version, boolean autologin, String clientToken, boolean passwordInURL) {
        super(TokenLoginRequest.createParameter(login, password, authId, client, version, autologin, clientToken, passwordInURL));
        this.clientToken = clientToken;
    }

    public TokenLoginRequest(String login, String password) {
        this(login, password, LoginTools.generateAuthId(), AJAXClient.class.getName(), "7.4.2", true, UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
    }

    public TokenLoginRequest(String login, String password, boolean passwordInURL) {
        this(login, password, LoginTools.generateAuthId(), AJAXClient.class.getName(), "7.4.2", true, UUIDs.getUnformattedString((UUID)UUID.randomUUID()), passwordInURL);
    }

    private static AJAXRequest.Parameter[] createParameter(String login, String password, String authId, String client, String version, boolean autologin, String clientToken, boolean passwordInURL) {
        ArrayList<AJAXRequest.Parameter> retval = new ArrayList<AJAXRequest.Parameter>();
        if (passwordInURL) {
            retval.add(new AJAXRequest.URLParameter("password", password));
        }
        retval.add(new AJAXRequest.URLParameter("action", "tokenLogin"));
        retval.add(new AJAXRequest.URLParameter("authId", authId));
        retval.add(new AJAXRequest.FieldParameter("login", login));
        retval.add(new AJAXRequest.FieldParameter("password", password));
        retval.add(new AJAXRequest.FieldParameter("client", client));
        retval.add(new AJAXRequest.FieldParameter("version", version));
        retval.add(new AJAXRequest.FieldParameter("autologin", Boolean.toString(autologin)));
        retval.add(new AJAXRequest.FieldParameter("clientToken", clientToken));
        return retval.toArray(new AJAXRequest.Parameter[retval.size()]);
    }

    public TokenLoginParser getParser() {
        return new TokenLoginParser(this.clientToken);
    }
}

