/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.LoginTools;
import com.openexchange.ajax.session.actions.LoginRequest;
import com.openexchange.ajax.session.actions.LoginResponse;
import com.openexchange.configuration.AJAXConfig;
import org.json.JSONObject;

public class Bug40821Test
extends AbstractAJAXSession {
    private String login;
    private String password;
    private AJAXClient clientToLogin;
    private String language;

    public Bug40821Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        AJAXConfig.init();
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
        this.clientToLogin = new AJAXClient(new AJAXSession(), true);
        GetRequest getRequest = new GetRequest(Tree.Language);
        GetResponse getResponse = this.client.execute(getRequest);
        this.language = getResponse.getString();
    }

    @Override
    public void tearDown() throws Exception {
        SetRequest setRequest = new SetRequest(Tree.Language, this.language);
        this.client.execute(setRequest);
        super.tearDown();
    }

    public void testLoginWithStoreLanguage() throws Exception {
        String languageToSet = "de_DE".equalsIgnoreCase(this.language) ? "en_US" : "de_DE";
        LoginRequest req = new LoginRequest(this.login, this.password, LoginTools.generateAuthId(), AJAXClient.class.getName(), "7.4.2", languageToSet, true, false);
        LoginResponse resp = this.clientToLogin.execute(req);
        this.clientToLogin.logout();
        JSONObject json = (JSONObject)resp.getData();
        String locale = json.getString("locale");
        Bug40821Test.assertEquals((String)"Language was not stored.", (String)languageToSet, (String)locale);
    }

    public void testLoginWithoutStoreLanguage() throws Exception {
        String languageToSet = "de_DE".equalsIgnoreCase(this.language) ? "en_US" : "de_DE";
        LoginRequest req = new LoginRequest(this.login, this.password, LoginTools.generateAuthId(), AJAXClient.class.getName(), "7.4.2", languageToSet, false, false);
        LoginResponse resp = this.clientToLogin.execute(req);
        this.clientToLogin.logout();
        JSONObject json = (JSONObject)resp.getData();
        String locale = json.getString("locale");
        Bug40821Test.assertEquals((String)"Language was stored.", (String)this.language, (String)locale);
    }
}

