/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.reminder.ReminderTest;
import com.openexchange.ajax.reminder.actions.DeleteRequest;
import com.openexchange.ajax.reminder.actions.RangeRequest;
import com.openexchange.ajax.reminder.actions.RangeResponse;
import com.openexchange.ajax.task.actions.InsertRequest;
import com.openexchange.ajax.task.actions.InsertResponse;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.groupware.tasks.Task;
import java.util.Date;
import java.util.TimeZone;
import org.junit.Test;

public class DeleteMultipleReminderTest
extends ReminderTest {
    private AJAXClient client;
    private Appointment appointment;
    private Task task;
    private ReminderObject[] reminders;
    private TimeZone timeZone;

    public DeleteMultipleReminderTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.timeZone = this.client.getValues().getTimeZone();
        this.task = new Task();
        this.task.setTitle("Test Reminder");
        this.task.setStartDate(new Date(System.currentTimeMillis() + 3600000L));
        this.task.setEndDate(new Date(System.currentTimeMillis() + 0x6DDD00L));
        this.task.setAlarm(new Date(System.currentTimeMillis() + 1800000L));
        this.task.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        InsertRequest taskInsert = new InsertRequest(this.task, this.timeZone);
        InsertResponse taskResponse = this.client.execute(taskInsert);
        taskResponse.fillTask(this.task);
        this.appointment = new Appointment();
        this.appointment.setTitle("Test Reminder");
        this.appointment.setStartDate(new Date(System.currentTimeMillis() + 3600000L));
        this.appointment.setEndDate(new Date(System.currentTimeMillis() + 0x6DDD00L));
        this.appointment.setAlarm(15);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        com.openexchange.ajax.appointment.action.InsertRequest appointmentInsert = new com.openexchange.ajax.appointment.action.InsertRequest(this.appointment, this.timeZone);
        AppointmentInsertResponse appointmentResponse = this.client.execute(appointmentInsert);
        appointmentResponse.fillAppointment(this.appointment);
        RangeRequest rngReq = new RangeRequest(new Date(System.currentTimeMillis() + 14400000L));
        RangeResponse rngRes = this.client.execute(rngReq);
        this.reminders = rngRes.getReminder(this.timeZone);
    }

    @Test
    public void testDeleteMultipleReminders() throws Exception {
        DeleteRequest delReq = new DeleteRequest(this.reminders, true);
        this.client.execute(delReq);
    }

    @Override
    public void tearDown() throws Exception {
        this.appointment.setLastModified(new Date(Long.MAX_VALUE));
        com.openexchange.ajax.appointment.action.DeleteRequest aDelReq = new com.openexchange.ajax.appointment.action.DeleteRequest(this.appointment);
        this.client.execute(aDelReq);
        com.openexchange.ajax.task.actions.DeleteRequest tDelReq = new com.openexchange.ajax.task.actions.DeleteRequest(this.task);
        super.tearDown();
    }
}

