/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.FolderTest;
import com.openexchange.ajax.config.ConfigTools;
import com.openexchange.ajax.reminder.ReminderTest;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.reminder.ReminderObject;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Bug6408Test
extends ReminderTest {
    public Bug6408Test(String name) {
        super(name);
    }

    public void testBug6408() throws Exception {
        ConfigTools.getUserId(this.getWebConversation(), this.getHostName(), this.getSessionId());
        TimeZone timeZone = ConfigTools.getTimeZone(this.getWebConversation(), this.getHostName(), this.getSessionId());
        Calendar c = Calendar.getInstance();
        c.setTimeZone(timeZone);
        c.add(5, 2);
        c.set(11, 8);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        long startTime = c.getTimeInMillis();
        long endTime = startTime + 3600000L;
        FolderObject folderObj = FolderTest.getStandardCalendarFolder(this.getWebConversation(), this.getHostName(), this.getSessionId());
        int folderId = folderObj.getObjectID();
        int alarmMinutes = 60;
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testBug6408");
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setShownAs(3);
        appointmentObj.setAlarm(60);
        appointmentObj.setParentFolderID(folderId);
        appointmentObj.setIgnoreConflicts(true);
        int targetId = AppointmentTest.insertAppointment(this.getWebConversation(), appointmentObj, timeZone, this.getHostName(), this.getSessionId());
        ReminderObject reminderObj = new ReminderObject();
        reminderObj.setTargetId(targetId);
        reminderObj.setFolder(folderId);
        reminderObj.setDate(new Date(startTime - 3600000L));
        ReminderObject[] reminderArray = Bug6408Test.listReminder(this.getWebConversation(), new Date(endTime), timeZone, this.getHostName(), this.getSessionId());
        int pos = -1;
        for (int a = 0; a < reminderArray.length; ++a) {
            if (reminderArray[a].getTargetId() != targetId) continue;
            pos = a;
            reminderObj.setObjectId(reminderArray[a].getObjectId());
            Bug6408Test.compareReminder(reminderObj, reminderArray[a]);
        }
        int newAlarmMinutes = 40320;
        appointmentObj.removeParentFolderID();
        appointmentObj.setAlarm(40320);
        long alarmInMillies = 2419200000L;
        reminderObj.setDate(new Date(startTime - 2419200000L));
        AppointmentTest.updateAppointment(this.getWebConversation(), appointmentObj, targetId, folderId, timeZone, this.getHostName(), this.getSessionId());
        reminderArray = Bug6408Test.listReminder(this.getWebConversation(), new Date(endTime), timeZone, this.getHostName(), this.getSessionId());
        boolean found = false;
        pos = -1;
        for (int a = 0; a < reminderArray.length; ++a) {
            if (reminderArray[a].getTargetId() != targetId) continue;
            pos = a;
            reminderObj.setObjectId(reminderArray[a].getObjectId());
            Bug6408Test.compareReminder(reminderObj, reminderArray[a]);
            found = true;
        }
        Bug6408Test.assertTrue((String)("no reminder find for target id " + targetId + " in response"), (boolean)found);
        Bug6408Test.deleteReminder(this.getWebConversation(), reminderArray[pos].getObjectId(), this.getHostName(), this.getSessionId());
        AppointmentTest.deleteAppointment(this.getWebConversation(), targetId, folderId, this.getHostName(), this.getSessionId(), false);
    }
}

