/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.onboarding.tests;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.onboarding.actions.ExecuteRequest;
import com.openexchange.ajax.onboarding.actions.OnboardingTestResponse;
import com.openexchange.ajax.onboarding.tests.PListDownloadTestHelper;
import com.openexchange.ajax.user.actions.SetAttributeRequest;
import com.openexchange.ajax.user.actions.SetAttributeResponse;
import com.openexchange.exception.OXException;
import java.io.UnsupportedEncodingException;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONObject;

public class PlistSMSTest
extends AbstractAJAXSession {
    private String name;
    private static final String SLASH = "/";
    private static final String UID = new UID(1).toString();
    private static final String[] SCENARIOS = new String[]{"apple.iphone/mailsync", "apple.iphone/eassync", "apple.iphone/davsync"};

    public PlistSMSTest(String name) {
        super(name);
        this.name = name;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        SetAttributeRequest req = new SetAttributeRequest(this.client.getValues().getUserId(), "user_sms_link_secret", UID, false);
        SetAttributeResponse response = this.client.execute(req);
        PlistSMSTest.assertNotNull((Object)((Object)response));
    }

    public void testExecute() throws Exception {
        String jsonString = "{\"sms\":\"0276183850\",\"code\":\"de\"}";
        JSONObject body = new JSONObject(jsonString);
        for (String id : SCENARIOS) {
            ExecuteRequest req = new ExecuteRequest(id, "sms", body, false);
            OnboardingTestResponse response = this.client.execute(req);
            PlistSMSTest.assertNotNull((String)"Response is empty!", (Object)((Object)response));
            PlistSMSTest.assertNotNull((String)"Unexpected response from the server! Response does not contain an exception.", (Object)((Object)response.getException()));
            PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain an wrong exception.", (int)1, (int)response.getException().getCode());
            PlistSMSTest.assertEquals((String)"Unexpected response from the server! Response does contain an wrong exception.", (String)"SIPGATE", (String)response.getException().getPrefix());
        }
    }

    public void testDownload() throws Exception {
        PListDownloadTestHelper helper = new PListDownloadTestHelper(this.name);
        String url = this.getURL(this.client.getValues().getUserId(), this.client.getValues().getContextId(), "mailsync", "apple.iphone");
        helper.testMailDownload(url, this.client.getHostname());
        url = this.getURL(this.client.getValues().getUserId(), this.client.getValues().getContextId(), "eassync", "apple.iphone");
        helper.testEASDownload(url, this.client.getHostname());
        url = this.getURL(this.client.getValues().getUserId(), this.client.getValues().getContextId(), "davsync", "apple.iphone");
        helper.testDavDownload(url, this.client.getHostname());
    }

    private String getURL(int userId, int contextId, String scenario, String device) throws OXException, NoSuchAlgorithmException, UnsupportedEncodingException {
        StringBuilder url = new StringBuilder();
        String userString = new String(Base64.encodeBase64((byte[])String.valueOf(userId).getBytes()));
        String contextString = new String(Base64.encodeBase64((byte[])String.valueOf(contextId).getBytes()));
        String scenarioString = new String(Base64.encodeBase64((byte[])scenario.getBytes()));
        String deviceString = new String(Base64.encodeBase64((byte[])device.getBytes()));
        String challenge = PlistSMSTest.toHash(userId, contextId, scenario, device);
        url.append("/ajax/plist");
        url.append(SLASH).append(userString).append(SLASH).append(contextString).append(SLASH).append(deviceString).append(SLASH).append(scenarioString).append(SLASH).append(challenge);
        return url.toString();
    }

    private static String toHash(int userId, int contextId, String scenario, String device) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String secret = UID;
        String challenge = userId + contextId + device + scenario + secret;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(challenge.getBytes("UTF-8"), 0, challenge.length());
        sha1hash = md.digest();
        return PlistSMSTest.convertToHex(sha1hash);
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }
}

